/**
 * Copyright (C) 2012  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.bar.BasicBarChart;
import org.dussan.dchartsdemo.charts.bar.HorizontalBarChartWithPointLabels;
import org.dussan.dchartsdemo.charts.bar.VerticalBarChartWithLegend;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.BarChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class BarCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(BarChart.values()[0].getDescription());
		for (int chart = 1; chart < BarChart.values().length; chart++) {
			tree.addItem(BarChart.values()[chart].getDescription());
			tree.setParent(BarChart.values()[chart].getDescription(),
					BarChart.values()[0].getDescription());
			tree.setChildrenAllowed(BarChart.values()[chart].getDescription(),
					false);
		}
		tree.expandItemsRecursively(BarChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (BarChart.fromString(chart)) {
		case BASIC:
			component = new BasicBarChart();
			break;
		case HORIZONTAL_WITH_POINT_LABELS:
			component = new HorizontalBarChartWithPointLabels();
			break;
		case VERICAL_WITH_LEGEND:
			component = new VerticalBarChartWithLegend();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.BAR.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (BarChart chart : BarChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
