/**
 * Copyright (C) 2012  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import javax.servlet.ServletContext;

public class ManifestReader {

	private static Properties manifestProperty = null;

	private static void initManifest(ServletContext context) {
		manifestProperty = new Properties();
		try {
			InputStream is = context
					.getResourceAsStream("/META-INF/MANIFEST.MF");
			InputStreamReader isReader = new InputStreamReader(is, "UTF-8");
			manifestProperty.load(new BufferedReader(isReader));
			isReader.close();
			is.close();
		} catch (IOException e) {
			manifestProperty = null;
		}
	}

	public static String getVersion(ServletContext context) {
		initManifest(context);
		if (manifestProperty != null) {
			return manifestProperty.getProperty("Application-Version");
		}
		return null;
	}

}
