/**
 * Copyright (C) 2012  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.line.BasicLineChart;
import org.dussan.dchartsdemo.charts.line.LineChartWithAxes;
import org.dussan.dchartsdemo.charts.line.LineChartWithHighlightingCursorAndTrendline;
import org.dussan.dchartsdemo.charts.line.LineChartWithLineStyleOptions;
import org.dussan.dchartsdemo.charts.line.LineChartWithMultipleAxis;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.LineChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class LineCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(LineChart.values()[0].getDescription());
		for (int chart = 1; chart < LineChart.values().length; chart++) {
			tree.addItem(LineChart.values()[chart].getDescription());
			tree.setParent(LineChart.values()[chart].getDescription(),
					LineChart.values()[0].getDescription());
			tree.setChildrenAllowed(LineChart.values()[chart].getDescription(),
					false);
		}
		tree.expandItemsRecursively(LineChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (LineChart.fromString(chart)) {
		case AXES:
			component = new LineChartWithAxes();
			break;
		case BASIC:
			component = new BasicLineChart();
			break;
		case HIGHLIGHTING_CURSOR_AND_TRENDLINE:
			component = new LineChartWithHighlightingCursorAndTrendline();
			break;
		case LINE_STYLE_OPTIONS:
			component = new LineChartWithLineStyleOptions();
			break;
		case MULTIPLE_AXIS:
			component = new LineChartWithMultipleAxis();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.LINE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (LineChart chart : LineChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
