/**
 * Copyright (C) 2012  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.bar;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.PointLabels;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.directions.BarDirections;
import org.dussan.vaadin.dcharts.metadata.locations.PointLabelLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.BarRenderer;

import com.vaadin.ui.Layout;

public class HorizontalBarChartWithPointLabels extends ChartContext {

	private static final long serialVersionUID = -5628761337434273180L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries().add(2, 1).add(4, 2).add(6, 3).add(3, 4);
		dataSeries.newSeries().add(5, 1).add(1, 2).add(3, 3).add(4, 4);
		dataSeries.newSeries().add(4, 1).add(7, 2).add(1, 3).add(2, 4);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR)
				.setPointLabels(
						new PointLabels().setShow(true)
								.setLocation(PointLabelLocations.EAST)
								.setEdgeTolerance(-15))
				.setShadowAngle(135)
				.setRendererOptions(
						new BarRenderer()
								.setBarDirection(BarDirections.HOTIZONTAL));

		Axes axes = new Axes().addAxis(new XYaxis(XYaxes.Y)
				.setRenderer(AxisRenderers.CATEGORY));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setAxes(axes);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar plot = $.jqplot('chart2', [\n"//
				+ "\t\t[[2,1], [4,2], [6,3], [3,4]],\n"//
				+ "\t\t[[5,1], [1,2], [3,3], [4,4]],\n"//
				+ "\t\t[[4,1], [7,2], [1,3], [2,4]]], {\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t\tpointLabels: { show: true, location: 'e', edgeTolerance: -15 },\n"//
				+ "\t\t\tshadowAngle: 135,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tbarDirection: 'horizontal'\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(2, 1)\n"//
				+ "\t.add(4, 2)\n"//
				+ "\t.add(6, 3)\n"//
				+ "\t.add(3, 4);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(5, 1)\n"//
				+ "\t.add(1, 2)\n"//
				+ "\t.add(3, 3)\n"//
				+ "\t.add(4, 4);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(4, 1)\n"//
				+ "\t.add(7, 2)\n"//
				+ "\t.add(1, 3)\n"//
				+ "\t.add(2, 4);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR)\n"//
				+ "\t.setPointLabels(\n"//
				+ "\t\tnew PointLabels()\n"//
				+ "\t\t\t.setShow(true)\n"//
				+ "\t\t\t.setLocation(PointLabelLocations.EAST)\n"//
				+ "\t\t\t.setEdgeTolerance(-15))\n"//
				+ "\t.setShadowAngle(135)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BarRenderer()\n"//
				+ "\t\t\t.setBarDirection(BarDirections.HOTIZONTAL));\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setAxes(axes);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
