/**
 * Copyright (C) 2012  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui;

import com.vaadin.ui.UriFragmentUtility;
import com.vaadin.ui.UriFragmentUtility.FragmentChangedListener;

public class UriTool extends UriFragmentUtility implements
		FragmentChangedListener {

	private static final long serialVersionUID = -7225350836330956166L;
	private boolean isAttached = false;
	private String fragment = new String();

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			addListener((FragmentChangedListener) this);
		}
	}

	@Override
	public void detach() {
		super.detach();
		if (isAttached) {
			isAttached = false;
			removeListener(this);
		}
	}

	@Override
	public void fragmentChanged(FragmentChangedEvent source) {
		getWindow().requestRepaintAll();
	}

	@Override
	public void setFragment(String fragment) {
		if (!this.fragment.equals(fragment)) {
			this.fragment = fragment;
			setFragment(fragment, true);
		}
	}

}
