/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui.tree;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.charts.types.BarChart;
import org.dussan.dchartsdemo.charts.types.BubbleChart;
import org.dussan.dchartsdemo.charts.types.DonutChart;
import org.dussan.dchartsdemo.charts.types.LineChart;
import org.dussan.dchartsdemo.charts.types.PieChart;
import org.dussan.dchartsdemo.charts.types.PyramidChart;

public enum ChartTypes {

	DEFAULT("", ""), //
	BAR(BarChart.DEFAULT.getPath(), BarChart.DEFAULT.getDescription()), //
	BUBBLE(BubbleChart.DEFAULT.getPath(), BubbleChart.DEFAULT
			.getDescription()), //
	DONUT(DonutChart.DEFAULT.getPath(), DonutChart.DEFAULT
			.getDescription()), //
	LINE(LineChart.DEFAULT.getPath(), LineChart.DEFAULT
			.getDescription()), //
	PIE(PieChart.DEFAULT.getPath(), PieChart.DEFAULT.getDescription()), //
	PYRAMID(PyramidChart.DEFAULT.getPath(), PyramidChart.DEFAULT
			.getDescription());

	private final List<String> charts;

	private ChartTypes(String... charts) {
		this.charts = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return charts;
	}

	public String getPath() {
		return charts.get(0);
	}

	public String getDescription() {
		return charts.get(1);
	}

	public static ChartTypes fromString(String chart) {
		if (chart != null) {
			for (ChartTypes tempChart : ChartTypes.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return getPath();
	}

}
