/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.line;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.base.renderers.MarkerRenderer;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.styles.MarkerStyles;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.Title;

import com.vaadin.ui.Layout;

public class LineChartWithLineStyleOptions extends ChartContext {

	private static final long serialVersionUID = -4654958708849127530L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, Math.cos(i));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, Math.sin(i - 0.8));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, 2.5 + Math.pow(i / 4, 2));
		}
		dataSeries.newSeries();
		for (float i = 0; i < 2 * Math.PI; i += 0.4) {
			dataSeries.add(i, -2.5 - Math.pow(i / 4, 2));
		}

		Title title = new Title("Line Style Options");

		Series series = new Series()
				.addSeries(
						new XYseries().setLineWidth(2).setMarkerOptions(
								new MarkerRenderer()
										.setStyle(MarkerStyles.DIAMOND)))
				.addSeries(
						new XYseries().setShowLine(false).setMarkerOptions(
								new MarkerRenderer().setSize(7).setStyle(
										MarkerStyles.X)))
				.addSeries(
						new XYseries().setMarkerOptions(new MarkerRenderer()
								.setStyle(MarkerStyles.CIRCLE)))
				.addSeries(
						new XYseries().setLineWidth(5)
								.setMarkerOptions(
										new MarkerRenderer().setStyle(
												MarkerStyles.FILLED_SQUARE)
												.setSize(10)));

		Options options = new Options().setTitle(title).setSeries(series);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function() {\n"//
				+ "\tvar cosPoints = [];\n"//
				+ "\tfor (var i = 0; i<2*Math.PI; i+=0.4) {\n"//
				+ "\t\tcosPoints.push([i, Math.cos(i)]);\n"//
				+ "\t}\n"//
				+ "\n"//
				+ "\tvar sinPoints = [];\n"//
				+ "\tfor (var i = 0; i<2*Math.PI; i+=0.4) {\n"//
				+ "\t\tsinPoints.push([i, 2 * Math.sin(i-.8)]);\n"//
				+ "\t}\n"//
				+ "\n"//
				+ "\tvar powPoints1 = [];\n"//
				+ "\tfor (var i = 0; i<2*Math.PI; i+=0.4) {\n"//
				+ "\t\tpowPoints1.push([i, 2.5 + Math.pow(i/4, 2)]);\n"//
				+ "\t}\n"//
				+ "\n"//
				+ "\tvar powPoints2 = [];\n"//
				+ "\tfor (var i = 0; i<2*Math.PI; i+=0.4) {\n"//
				+ "\t\tpowPoints2.push([i, -2.5 - Math.pow(i/4, 2)]);\n"//
				+ "\t}\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('chart3', [cosPoints, sinPoints, powPoints1, powPoints2], {\n"//
				+ "\t\ttitle: 'Line Style Options',\n"//
				+ "\t\tseries: [{\n"//
				+ "\t\t\tlineWidth: 2,\n"//
				+ "\t\t\tmarkerOptions: { style: \"dimaond\" }\n"//
				+ "\t\t},\n"//
				+ "\t\t{\n"//
				+ "\t\t\tshowLine: false,\n"//
				+ "\t\t\tmarkerOptions: { size: 7, style: \"x\" }\n"//
				+ "\t\t},\n"//
				+ "\t\t{\n"//
				+ "\t\t\tmarkerOptions: { style: \"circle\" }\n"//
				+ "\t\t},\n"//
				+ "\t\t{\n"//
				+ "\t\t\tlineWidth: 5,\n"//
				+ "\t\t\tmarkerOptions: { style: \"filledSquare\", size: 10 }\n"//
				+ "\t\t}]\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.newSeries();\n"//
				+ "for (float i = 0; i < 2 * Math.PI; i += 0.4) {\n"//
				+ "\tdataSeries.add(i, Math.cos(i));\n"//
				+ "}\n"//
				+ "dataSeries.newSeries();\n"//
				+ "for (float i = 0; i < 2 * Math.PI; i += 0.4) {\n"//
				+ "\tdataSeries.add(i, Math.sin(i - 0.8));\n"//
				+ "}\n"//
				+ "dataSeries.newSeries();\n"//
				+ "for (float i = 0; i < 2 * Math.PI; i += 0.4) {\n"//
				+ "\tdataSeries.add(i, 2.5 + Math.pow(i / 4, 2));\n"//
				+ "}\n"//
				+ "dataSeries.newSeries();\n"//
				+ "for (float i = 0; i < 2 * Math.PI; i += 0.4) {\n"//
				+ "\tdataSeries.add(i, -2.5 - Math.pow(i / 4, 2));\n"//
				+ "}\n"//
				+ "\n"//
				+ "Title title = new Title(\"Line Style Options\");\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setLineWidth(2)\n"//
				+ "\t\t\t.setMarkerOptions(\n"//
				+ "\t\t\t\tnew MarkerRenderer()\n"//
				+ "\t\t\t\t\t.setStyle(MarkerStyles.DIAMOND)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries().\n"//
				+ "\t\t\tsetShowLine(false)\n"//
				+ "\t\t\t.setMarkerOptions(\n"//
				+ "\t\t\t\tnew MarkerRenderer()\n"//
				+ "\t\t\t\t\t.setSize(7)\n"//
				+ "\t\t\t\t\t.setStyle(MarkerStyles.X)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setMarkerOptions(\n"//
				+ "\t\t\t\tnew MarkerRenderer()\n"//
				+ "\t\t\t\t\t.setStyle(MarkerStyles.CIRCLE)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setLineWidth(5)\n"//
				+ "\t\t\t.setMarkerOptions(\n"//
				+ "\t\t\t\tnew MarkerRenderer()\n"//
				+ "\t\t\t\t\t.setStyle(MarkerStyles.FILLED_SQUARE)\n"//
				+ "\t\t\t\t\t.setSize(10)));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setTitle(title)\n"//
				+ "\t.setSeries(series);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
