/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui.context;

import java.util.List;

import org.dussan.vaadin.dcharts.DCharts;
import org.vaadin.codemirror2.CodeMirror;
import org.vaadin.codemirror2.client.ui.CodeMode;
import org.vaadin.codemirror2.client.ui.CodeTheme;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;

public abstract class ChartContext extends VerticalLayout {

	private static final long serialVersionUID = -4543823471416442797L;
	private boolean isAttached = false;
	private HorizontalLayout codelLayout = new HorizontalLayout();

	public ChartContext() {
		setSizeFull();
		setSpacing(true);
		codelLayout.setStyleName("chartCode");
		codelLayout.setSizeUndefined();
		codelLayout.setWidth(100, UNITS_PERCENTAGE);
		codelLayout.setHeight(null);
		codelLayout.setSpacing(true);
		codelLayout.setMargin(true, false, false, false);
	}

	abstract protected void init();

	protected void setChart(DCharts chart) {
		addComponent(chart);
		addComponent(codelLayout);
		setComponentAlignment(chart, Alignment.TOP_CENTER);
		chart.show();
	}

	protected void setJqPlotCode(Object text) {
		HorizontalLayout context = new HorizontalLayout();
		context.setWidth(100, UNITS_PERCENTAGE);
		context.setMargin(false, true, false, true);
		codelLayout.addComponent(context);
		codelLayout.setExpandRatio(context, 1.0f);
		codelLayout.setComponentAlignment(context, Alignment.TOP_CENTER);

		CodeMirror code = new CodeMirror("jqPlot Code");
		code.setSizeUndefined();
		code.setWidth(99, UNITS_PERCENTAGE);
		code.setHeight(null);
		code.setColumns(0);
		code.setShowLineNumbers(true);
		code.setCodeMode(CodeMode.JAVA);
		code.setCodeTheme(CodeTheme.NEAT);
		code.setValue(text);
		context.addComponent(code);
	}

	protected void setDChatsCode(Object text) {
		HorizontalLayout context = new HorizontalLayout();
		context.setWidth(100, UNITS_PERCENTAGE);
		context.setMargin(false, true, false, true);
		codelLayout.addComponent(context);
		codelLayout.setExpandRatio(context, 1.0f);
		codelLayout.setComponentAlignment(context, Alignment.TOP_CENTER);

		CodeMirror code = new CodeMirror("dCharts Code");
		code.setSizeUndefined();
		code.setWidth(99, UNITS_PERCENTAGE);
		code.setHeight(null);
		code.setColumns(0);
		code.setShowLineNumbers(true);
		code.setCodeMode(CodeMode.JAVA);
		code.setCodeTheme(CodeTheme.NEAT);
		code.setValue(text);
		context.addComponent(code);
	}
	
	public static void addMenus(List< String> descriptions){
		
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			init();
		}
	}

}
