package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.pie.BasicPieChart;
import org.dussan.dchartsdemo.charts.pie.PieChartWithDataLabels;
import org.dussan.dchartsdemo.charts.pie.PieChartWithEmptySlices;
import org.dussan.dchartsdemo.charts.pie.PieChartWithLegend;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.PieChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class PieCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(PieChart.values()[0].getDescription());
		for (int chart = 1; chart < PieChart.values().length; chart++) {
			tree.addItem(PieChart.values()[chart].getDescription());
			tree.setParent(PieChart.values()[chart].getDescription(),
					PieChart.values()[0].getDescription());
			tree.setChildrenAllowed(PieChart.values()[chart].getDescription(),
					false);
		}
		tree.expandItemsRecursively(PieChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (PieChart.fromString(chart)) {
		case BASIC:
			component = new BasicPieChart();
			break;
		case DATA_LABELS:
			component = new PieChartWithDataLabels();
			break;
		case EMPTY_SLICES:
			component = new PieChartWithEmptySlices();
			break;
		case LEGEND:
			component = new PieChartWithLegend();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.PIE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (PieChart chart : PieChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
