package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum DonutChart implements ChartType {

	DEFAULT("donutCharts", "Donut charts"), //
	BASIC("basic", "Basic donut chart"), //
	DATA_LABELS_AND_LEGEND("dataLabelsAndLegend", "With data labels and legend");

	private final List<String> chart;

	private DonutChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static DonutChart fromString(String chart) {
		if (chart != null) {
			for (DonutChart tempChart : DonutChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
