package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.pyramid.BasicPyramidChart;
import org.dussan.dchartsdemo.charts.pyramid.PyramidChartWithMiddleAxis;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.PyramidChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class PyramidCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(PyramidChart.values()[0].getDescription());
		for (int chart = 1; chart < PyramidChart.values().length; chart++) {
			tree.addItem(PyramidChart.values()[chart].getDescription());
			tree.setParent(PyramidChart.values()[chart].getDescription(),
					PyramidChart.values()[0].getDescription());
			tree.setChildrenAllowed(
					PyramidChart.values()[chart].getDescription(), false);
		}
		tree.expandItemsRecursively(PyramidChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (PyramidChart.fromString(chart)) {
		case BASIC:
			component = new BasicPyramidChart();
			break;
		case WITH_MIDDLE_AXIS:
			component = new PyramidChartWithMiddleAxis();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.PYRAMID.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (PyramidChart chart : PyramidChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
