package org.dussan.dchartsdemo.charts.pie;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;

import com.vaadin.ui.Layout;

public class BasicPieChart extends ChartContext {

	private static final long serialVersionUID = 2178588140164286363L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries().add("none", 23)
				.add("error", 0).add("click", 5).add("impression", 25);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.PIE);

		Options options = new Options().setSeriesDefaults(seriesDefaults);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar plot = $.jqplot('pie', [[[\"none\",23],[\"error\",0],[\"click\",5],[\"impression\",25]]], {\n"//
				+ "\t\tseriesDefaults:{ renderer: $.jqplot.PieRenderer }\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"none\", 23)\n"//
				+ "\t.add(\"error\", 0)\n"//
				+ "\t.add(\"click\", 5)\n"//
				+ "\t.add(\"impression\", 25);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.PIE);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
