package org.dussan.dchartsdemo.charts.summary;

import java.util.Map;
import java.util.Map.Entry;

import org.dussan.dchartsdemo.DChartsDemoWindow;

import com.vaadin.event.MouseEvents.ClickEvent;
import com.vaadin.event.MouseEvents.ClickListener;
import com.vaadin.terminal.ThemeResource;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;

public class ChartsSummary extends VerticalLayout {

	private static final long serialVersionUID = 2732668125860378592L;
	private boolean isAttached = false;
	private Map<String, Map<String, String>> charts = null;

	public ChartsSummary(Map<String, Map<String, String>> charts) {
		this.charts = charts;
	}

	private void init() {
		setSizeUndefined();
		setWidth(100, UNITS_PERCENTAGE);

		for (Entry<String, Map<String, String>> chart : charts.entrySet()) {
			String chartType = chart.getKey();
			Map<String, String> charts = chart.getValue();

			VerticalLayout chartsLayout = new VerticalLayout();
			chartsLayout.setSizeUndefined();
			chartsLayout.setWidth(100, UNITS_PERCENTAGE);
			chartsLayout.setStyleName("chartsLayout");
			addComponent(chartsLayout);

			Label chartTypeLabel = new Label();
			chartTypeLabel.setWidth(100, UNITS_PERCENTAGE);
			chartTypeLabel.setStyleName("chartTypeLabel");
			chartsLayout.addComponent(chartTypeLabel);

			CssLayout cssLayout = new CssLayout();
			cssLayout.setSizeUndefined();
			cssLayout.setWidth(100, UNITS_PERCENTAGE);
			chartsLayout.addComponent(cssLayout);

			for (Entry<String, String> tempChart : charts.entrySet()) {
				String chartName = tempChart.getKey();
				String chartDescription = tempChart.getValue();
				if (chartType.equals(chartName)) {
					chartTypeLabel.setValue(chartDescription);
				} else {
					VerticalLayout chartLayout = new VerticalLayout();
					chartLayout.setSizeUndefined();
					chartLayout.setStyleName("chartLayout");
					cssLayout.addComponent(chartLayout);

					Embedded chartImage = new Embedded(null, new ThemeResource(
							"images/" + chartType + "/" + chartName + ".png"));
					chartImage.setStyleName("chartImage");
					chartImage.setDebugId(chartType + "/" + chartName);
					chartLayout.addComponent(chartImage);

					Label chartLabel = new Label(chartDescription);
					chartLabel.setStyleName("chartLabel");
					chartLayout.addComponent(chartLabel);
					chartImage.addListener(new ClickListener() {
						private static final long serialVersionUID = 301424711026984913L;

						@Override
						public void click(ClickEvent event) {
							String fragment = event.getComponent().getDebugId();
							((DChartsDemoWindow) getApplication()
									.getMainWindow()).getUriTool().setFragment(
									fragment);
						};
					});
				}
			}
		}
	}

	@Override
	public void attach() {
		if (!isAttached) {
			isAttached = true;
			init();
		}
	}

}
