package org.dussan.dchartsdemo;

import org.dussan.dchartsdemo.ui.Header;
import org.dussan.dchartsdemo.ui.UriTool;
import org.dussan.dchartsdemo.ui.context.ContextPanel;
import org.dussan.dchartsdemo.ui.tree.TreePanel;

import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Window;

public class DChartsDemoWindow extends Window {

	private static final long serialVersionUID = 7038630410919798590L;
	private boolean isAttached = false;
	private UriTool uriTool = null;

	public DChartsDemoWindow(String title) {
		super.setCaption(title);
		init();
	}

	private void init() {
		GridLayout main = new GridLayout(2, 2);
		main.setStyleName("demo");
		main.setSizeFull();
		main.setSpacing(false);
		main.setRowExpandRatio(1, 1.0f);
		main.setColumnExpandRatio(1, 1.0f);
		setContent(main);

		main.addComponent(new Header(), 0, 0, 1, 0);
		main.addComponent(new TreePanel(), 0, 1);
		main.addComponent(new ContextPanel(), 1, 1);

		uriTool = new UriTool();
		addComponent(uriTool);
	}

	public UriTool getUriTool() {
		return uriTool;
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
		}
	}

}
