package org.dussan.dchartsdemo.charts.pyramid;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.PyramidSides;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.Yaxes;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.PyramidRenderer;

import com.vaadin.ui.Layout;

public class PyramidChartWithMiddleAxis extends ChartContext {

	private static final long serialVersionUID = 1808225045531702256L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries()
				.add(0.635441, 1.066868, 0.889602, 0.816883, 1.016458,
						0.916705, 0.79569, 0.970443, 1.046451, 1.335686)
				.add(0.767078, 0.679554, 1.064493, 0.915063, 0.860792,
						0.785728, 0.892471, 0.687886, 1.055313, 0.921839)
				.add(0.230476, 0.175917, 0.225027, 0.40564, 0.408617, 0.495873,
						0.441314, 0.282774, 0.47483, 0.393433)
				.add(0.203297, 0.298698, 0.452947, 0.783013, 0.50033, 0.53629,
						0.451817, 0.69927, 0.741356, 0.545433);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRendererOptions(new PyramidRenderer().setBarPadding(3)
						.setOffsetBars(true));

		Series series = new Series()
				.addSeries(
						new XYseries().setYaxis(Yaxes.Y_MIDDLE)
								.setRendererOptions(
										new PyramidRenderer()
												.setSide(PyramidSides.LEFT)))
				.addSeries(
						new XYseries(Yaxes.Y2).setYaxis(Yaxes.Y_MIDDLE)
								.setRendererOptions(
										new PyramidRenderer()
												.setSide(PyramidSides.RIGHT)))
				.addSeries(
						new XYseries().setYaxis(Yaxes.Y_MIDDLE)
								.setRendererOptions(
										new PyramidRenderer().setSide(
												PyramidSides.LEFT).setFill(
												false)))
				.addSeries(
						new XYseries(Yaxes.Y2).setYaxis(Yaxes.Y_MIDDLE)
								.setRendererOptions(
										new PyramidRenderer().setSide(
												PyramidSides.RIGHT).setFill(
												false)));

		Axes axes = new Axes().addAxis(new XYaxis().setAxis(XYaxes.Y_MIDDLE)
				.setLabel("Age")
				.setTicks(new Ticks().add(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
				.setTickInterval(2));

		Options options = new Options()
				.setTitle(
						"<div style='float:left;width:50%;text-align:center'>Male</div><div style='float:right;width:50%;text-align:center'>Female</div>")
				.setSeriesDefaults(seriesDefaults).setSeries(series)
				.setAxes(axes);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar male = [0.635441, 1.066868, 0.889602, 0.816883, 1.016458, 0.916705, 0.79569, 0.970443, 1.046451, 1.335686];\n"//
				+ "\tvar female = [0.767078, 0.679554, 1.064493, 0.915063, 0.860792, 0.785728, 0.892471, 0.687886, 1.055313, 0.921839];\n"//
				+ "\tvar male1 = [0.230476, 0.175917, 0.225027, 0.40564, 0.408617, 0.495873, 0.441314, 0.282774, 0.47483, 0.393433];\n"//
				+ "\tvar female1 = [0.203297, 0.298698, 0.452947, 0.783013, 0.50033, 0.53629, 0.451817, 0.69927, 0.741356, 0.545433];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('pyramid', [male, female, male1, female1], {\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tbarPadding: 3,\n"//
				+ "\t\t\t\toffsetBars: true\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\tseries: [{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"yaxis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"left\"}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\t{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"y2axis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"right\"}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\t{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"yaxis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"left\", fill: false}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\t{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"y2axis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"right\", fill: false}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}],\n"//
				+ "\t\ttitle: {\n"//
				+ "\t\t\ttext: \"<div style='float:left;width:50%;text-align:center'>Male</div><div style='float:right;width:50%;text-align:center'>Female</div>\"\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\tyMidAxis: {\n"//
				+ "\t\t\t\tname: \"yMidAxis\",\n"//
				+ "\t\t\t\tlabel: \"Age\",\n"//
				+ "\t\t\t\tticks: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],\n"//
				+ "\t\t\t\ttickInterval: 2.0\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(0.635441, 1.066868, 0.889602, 0.816883, 1.016458, 0.916705, 0.79569, 0.970443, 1.046451, 1.335686)\n"//
				+ "\t.add(0.767078, 0.679554, 1.064493, 0.915063, 0.860792, 0.785728, 0.892471, 0.687886, 1.055313, 0.921839)\n"//
				+ "\t.add(0.230476, 0.175917, 0.225027, 0.40564, 0.408617, 0.495873, 0.441314, 0.282774, 0.47483, 0.393433)\n"//
				+ "\t.add(0.203297, 0.298698, 0.452947, 0.783013, 0.50033, 0.53629, 0.451817, 0.69927, 0.741356, 0.545433);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t.setBarPadding(3)\n"//
				+ "\t\t\t.setOffsetBars(true));\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.LEFT)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries(Yaxes.Y2)\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.RIGHT)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.LEFT)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries(Yaxes.Y2)\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.RIGHT)));\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setAxis(XYaxes.Y_MIDDLE)\n"//
				+ "\t\t\t.setLabel(\"Age\")\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))\n"//
				+ "\t\t\t.setTickInterval(2));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setTitle(\"<div style='float:left;width:50%;text-align:center'>Male</div><div style='float:right;width:50%;text-align:center'>Female</div>\")\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setSeries(series)\n"//
				+ "\t.setAxes(axes);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}
}
