package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum BubbleChart implements ChartType {

	DEFAULT("bubbleCharts", "Bubble charts"), //
	BASIC("basic", "Basic bubble chart"), //
	TRANSPARENT_BUBBLES("transparentBubbles", "With trasnparent bubbles");

	private final List<String> chart;

	private BubbleChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static BubbleChart fromString(String chart) {
		if (chart != null) {
			for (BubbleChart tempChart : BubbleChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
