package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum PyramidChart implements ChartType {

	DEFAULT("pyramidCharts", "Pyramid charts"), //
	BASIC("basic", "Basic pyramid chart"), //
	WITH_MIDDLE_AXIS("withMiddleAxis", "With middle axis");

	private final List<String> chart;

	private PyramidChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static PyramidChart fromString(String chart) {
		if (chart != null) {
			for (PyramidChart tempChart : PyramidChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
