package org.dussan.dchartsdemo.charts.line;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;

import com.vaadin.ui.Layout;

public class BasicLineChart extends ChartContext {

	private static final long serialVersionUID = 3767138228407959194L;

	@Override
	protected void init() {
		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(new DataSeries().add(3, 7, 9, 1, 4, 6, 8, 2, 5));

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"
				+ "\tvar plot = $.jqplot ('chart1', [[3,7,9,1,4,6,8,2,5]]);\n"
				+ "});");
		setDChatsCode("DCharts chart = new DCharts();\n"
				+ "chart.setDataSeries(\n"
				+ "\tnew DataSeries()\n"
				+ "\t\t.add(3, 7, 9, 1, 4, 6, 8, 2, 5))\n"
				+ "\t.show();");
	}

}
