package org.dussan.dchartsdemo.ui;

import com.vaadin.ui.UriFragmentUtility;
import com.vaadin.ui.UriFragmentUtility.FragmentChangedListener;

public class UriTool extends UriFragmentUtility implements
		FragmentChangedListener {

	private static final long serialVersionUID = -7225350836330956166L;
	private boolean isAttached = false;
	private String fragment = new String();

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			addListener((FragmentChangedListener) this);
		}
	}

	@Override
	public void detach() {
		super.detach();
		if (isAttached) {
			isAttached = false;
			removeListener(this);
		}
	}

	@Override
	public void fragmentChanged(FragmentChangedEvent source) {
		getWindow().requestRepaintAll();
	}

	@Override
	public void setFragment(String fragment) {
		if (!this.fragment.equals(fragment)) {
			this.fragment = fragment;
			setFragment(fragment, true);
		}
	}

}
