package org.dussan.dchartsdemo.charts.bar;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;

import com.vaadin.ui.Layout;

public class BasicBarChart extends ChartContext {

	private static final long serialVersionUID = -3679249639565843052L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().add(2, 6, 7, 10);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR);

		Axes axes = new Axes().addAxis(new XYaxis().setRenderer(
				AxisRenderers.CATEGORY).setTicks(
				new Ticks().add("a", "b", "c", "d")));

		Highlighter highlighter = new Highlighter().setShow(false);

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setAxes(axes).setHighlighter(highlighter);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [2, 6, 7, 10];\n"//
				+ "\tvar ticks = ['a', 'b', 'c', 'd'];\n"//
				+ "\n"//
				+ "\tplot = $.jqplot('chart1', [s1], {\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer,\n"//
				+ "\t\t\t\tticks: ticks\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\thighlighter: { show: false }\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(2, 6, 7, 10);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY)\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(\"May\", \"June\", \"July\", \"August\")))\n"//
				+ "\n"//
				+ "Highlighter highlighter = new Highlighter()\n"//
				+ "\t.setShow(false);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setHighlighter(highlighter);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
