package org.dussan.dchartsdemo.charts.bubble;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.options.Title;
import org.dussan.vaadin.dcharts.renderers.series.BubbleRenderer;

import com.vaadin.ui.Layout;

public class BasicBubbleChart extends ChartContext {

	private static final long serialVersionUID = -7580283365090067338L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries()
				.add(11, 123, 1236, "Acura").add(45, 92, 1067, "Alfa Romeo")
				.add(24, 104, 1176, "AM General")
				.add(50, 23, 610, "Aston Martin Lagonda")
				.add(18, 17, 539, "Audi").add(7, 89, 864, "BMW")
				.add(2, 13, 1026, "Bugatti");

		Title title = new Title("Bubble Chart with Gradient Fills");

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BUBBLE)
				.setRendererOptions(
						new BubbleRenderer().setBubbleGradients(true))
				.setShadow(true);

		Options options = new Options().setTitle(title).setSeriesDefaults(
				seriesDefaults);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\n"//
				+ "\tvar arr = [[11, 123, 1236, \"Acura\"], [45, 92, 1067, \"Alfa Romeo\"],\n"//
				+ "\t[24, 104, 1176, \"AM General\"], [50, 23, 610, \"Aston Martin Lagonda\"],\n"//
				+ "\t[18, 17, 539, \"Audi\"], [7, 89, 864, \"BMW\"], [2, 13, 1026, \"Bugatti\"]];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('chart',[arr],{\n"//
				+ "\t\ttitle: 'Bubble Chart with Gradient Fills',\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer: $.jqplot.BubbleRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tbubbleGradients: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tshadow: true\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(11, 123, 1236, \"Acura\")\n"//
				+ "\t.add(45, 92, 1067, \"Alfa Romeo\")\n"//
				+ "\t.add(24, 104, 1176, \"AM General\")\n"//
				+ "\t.add(50, 23, 610, \"Aston Martin Lagonda\")\n"//
				+ "\t.add(18, 17, 539, \"Audi\")\n"//
				+ "\t.add(7, 89, 864, \"BMW\")\n"//
				+ "\t.add(2, 13, 1026, \"Bugatti\");\n"//
				+ "\n"//
				+ "Title title = new Title(\"Bubble Chart with Gradient Fills\");\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BUBBLE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BubbleRenderer()\n"//
				+ "\t\t\t.setBubbleGradients(true))\n"//
				+ "\t.setShadow(true);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setTitle(title)\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
