package org.dussan.dchartsdemo.ui.context;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.DChartsDemoWindow;
import org.dussan.dchartsdemo.charts.BarCharts;
import org.dussan.dchartsdemo.charts.BubbleCharts;
import org.dussan.dchartsdemo.charts.DonutCharts;
import org.dussan.dchartsdemo.charts.LineCharts;
import org.dussan.dchartsdemo.charts.PieCharts;
import org.dussan.dchartsdemo.charts.PyramidCharts;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.BarChart;
import org.dussan.dchartsdemo.charts.types.BubbleChart;
import org.dussan.dchartsdemo.charts.types.DonutChart;
import org.dussan.dchartsdemo.charts.types.LineChart;
import org.dussan.dchartsdemo.charts.types.PieChart;
import org.dussan.dchartsdemo.charts.types.PyramidChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;
import org.dussan.dchartsdemo.ui.tree.TreePanel;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;

public class ContextPanel extends Panel {

	private static final long serialVersionUID = -4017183034674379244L;
	private boolean isAttached = false;
	private String fragment = null;
	private Component component = null;
	private VerticalLayout contextLayout = null;

	public ContextPanel() {
	}

	private void init() {
		setSizeFull();
		contextLayout = (VerticalLayout) super.getContent();
		contextLayout.setStyleName("context");
		contextLayout.setSizeUndefined();
		contextLayout.setWidth(100, UNITS_PERCENTAGE);
		contextLayout.setHeight(null);
		fragment = new String();
	}

	private ChartsTree getChartsTree() {
		if (getApplication() != null
				&& getApplication().getMainWindow() != null) {
			for (Iterator<Component> componentIterator = getApplication()
					.getMainWindow().getComponentIterator(); componentIterator
					.hasNext();) {
				Component component = componentIterator.next();
				if (component instanceof TreePanel) {
					for (Iterator<Component> treeIterator = ((TreePanel) component)
							.getComponentIterator(); treeIterator.hasNext();) {
						Component treeComponent = treeIterator.next();
						if (treeComponent instanceof ChartsTree) {
							return (ChartsTree) treeComponent;
						}
					}
				}
			}
		}
		return null;
	}

	private Component replaceChartComponent(Component oldComponent,
			Component newComponent) {
		if (!oldComponent.equals(newComponent)) {
			contextLayout.replaceComponent(oldComponent, newComponent);
			contextLayout.setComponentAlignment(newComponent,
					Alignment.TOP_CENTER);
		}
		return newComponent;
	}

	private Map<String, Map<String, String>> addCharts() {
		Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();

		charts.put(ChartTypes.LINE.getPath(), LineCharts.getCharts());
		charts.put(ChartTypes.BAR.getPath(), BarCharts.getCharts());
		charts.put(ChartTypes.PIE.getPath(), PieCharts.getCharts());
		charts.put(ChartTypes.DONUT.getPath(), DonutCharts.getCharts());
		charts.put(ChartTypes.BUBBLE.getPath(), BubbleCharts.getCharts());
		charts.put(ChartTypes.PYRAMID.getPath(), PyramidCharts.getCharts());

		return charts;
	}

	private void processRepaintRequest(String request) {
		String chartDescription = new String();
		String chartType = request.isEmpty() ? request : request.split("/")[0];
		String chart = !request.isEmpty() && request.contains("/") ? request
				.split("/")[1] : new String();
		Component tempComponent = null;

		switch (ChartTypes.fromString(chartType)) {
		case BAR:
			tempComponent = BarCharts.processChart(chart);
			chartDescription = BarChart.fromString(chart).getDescription();
			break;
		case BUBBLE:
			tempComponent = BubbleCharts.processChart(chart);
			chartDescription = BubbleChart.fromString(chart).getDescription();
			break;
		case DONUT:
			tempComponent = DonutCharts.processChart(chart);
			chartDescription = DonutChart.fromString(chart).getDescription();
			break;
		case LINE:
			tempComponent = LineCharts.processChart(chart);
			chartDescription = LineChart.fromString(chart).getDescription();
			break;
		case PIE:
			tempComponent = PieCharts.processChart(chart);
			chartDescription = PieChart.fromString(chart).getDescription();
			break;
		case PYRAMID:
			tempComponent = PyramidCharts.processChart(chart);
			chartDescription = PyramidChart.fromString(chart).getDescription();
			break;
		case DEFAULT:
		default:
			tempComponent = new ChartsSummary(addCharts());
			break;
		}

		component = replaceChartComponent(component, tempComponent);
		if (tempComponent instanceof ChartsSummary) {
			getChartsTree().unselect(getChartsTree().getValue());
		} else {
			getChartsTree().setValue(chartDescription);
		}
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			init();

			component = new ChartsSummary(addCharts());
			contextLayout.addComponent(component);
		}
	}

	@Override
	public void requestRepaint() {
		String fragment = !(isAttached
				&& getApplication().getMainWindow() != null && ((DChartsDemoWindow) getApplication()
				.getMainWindow()).getUriTool() != null) ? new String()
				: ((DChartsDemoWindow) getApplication().getMainWindow())
						.getUriTool().getFragment();
		if (this.fragment != null && !this.fragment.equals(fragment)) {
			processRepaintRequest(this.fragment = fragment);
		}
		super.requestRepaint();
	}

}
