package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.bubble.BasicBubbleChart;
import org.dussan.dchartsdemo.charts.bubble.BubbleChartWithTransparentBubbles;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.BubbleChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class BubbleCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(BubbleChart.values()[0].getDescription());
		for (int chart = 1; chart < BubbleChart.values().length; chart++) {
			tree.addItem(BubbleChart.values()[chart].getDescription());
			tree.setParent(BubbleChart.values()[chart].getDescription(),
					BubbleChart.values()[0].getDescription());
			tree.setChildrenAllowed(
					BubbleChart.values()[chart].getDescription(), false);
		}
		tree.expandItemsRecursively(BubbleChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (BubbleChart.fromString(chart)) {
		case BASIC:
			component = new BasicBubbleChart();
			break;
		case TRANSPARENT_BUBBLES:
			component = new BubbleChartWithTransparentBubbles();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.BUBBLE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (BubbleChart chart : BubbleChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
