package org.dussan.dchartsdemo.charts.bar;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.LegendPlacements;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.tick.AxisTickRenderer;

import com.vaadin.ui.Layout;

public class VerticalBarChartWithLegend extends ChartContext {

	private static final long serialVersionUID = -7838462611956189899L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.add(200, 600, 700, 1000);
		dataSeries.add(460, -210, 690, 820);
		dataSeries.add(-260, -440, 320, 200);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setFillToZero(true).setRenderer(SeriesRenderers.BAR);

		Series series = new Series()
				.addSeries(new XYseries().setLabel("Hotel"))
				.addSeries(new XYseries().setLabel("Event Regristration"))
				.addSeries(new XYseries().setLabel("Airfare"));

		Legend legend = new Legend().setShow(true).setPlacement(
				LegendPlacements.OUTSIDE_GRID);

		Axes axes = new Axes().addAxis(
				new XYaxis().setRenderer(AxisRenderers.CATEGORY).setTicks(
						new Ticks().add("May", "June", "July", "August")))
				.addAxis(
						new XYaxis(XYaxes.Y).setPad(1.05f).setTickOptions(
								new AxisTickRenderer().setFormatString("$%d")));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setSeries(series).setLegend(legend).setAxes(axes);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [200, 600, 700, 1000];\n"//
				+ "\tvar s2 = [460, -210, 690, 820];\n"//
				+ "\tvar s3 = [-260, -440, 320, 200];\n"//
				+ "\tvar ticks = ['May', 'June', 'July', 'August'];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('chart1', [s1, s2, s3], {\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t\trendererOptions: {fillToZero: true}\n"//
				+ "\t\t},\n"//
				+ "\t\tseries:[\n"//
				+ "\t\t\t{label:'Hotel'},\n"//
				+ "\t\t\t{label:'Event Regristration'},\n"//
				+ "\t\t\t{label:'Airfare'}\n"//
				+ "\t\t],\n"//
				+ "\t\tlegend: {\n"//
				+ "\t\t\tshow: true,\n"//
				+ "\t\t\tplacement: 'outsideGrid'\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer,\n"//
				+ "\t\t\t\tticks: ticks\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\tpad: 1.05,\n"//
				+ "\t\t\t\ttickOptions: {formatString: '$%d'}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.add(200, 600, 700, 1000);\n"//
				+ "dataSeries.add(460, -210, 690, 820);\n"//
				+ "dataSeries.add(-260, -440, 320, 200);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setFillToZero(true)\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR);\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setLabel(\"Hotel\"))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setLabel(\"Event Regristration\"))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setLabel(\"Airfare\"));\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setPlacement(LegendPlacements.OUTSIDE_GRID);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY)\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(\"May\", \"June\", \"July\", \"August\")))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setPad(1.05f)\n"//
				+ "\t\t\t.setTickOptions(\n"//
				+ "\t\t\t\tnew AxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setFormatString(\"$%d\")));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setSeries(series)\n"//
				+ "\t.setLegend(legend)\n"//
				+ "\t.setAxes(axes);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
