package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.donut.BasicDonutChart;
import org.dussan.dchartsdemo.charts.donut.DonutChartWithDataLabelsAndLegend;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.DonutChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class DonutCharts {

	public static void addMenus(final Tree tree) {
		tree.addItem(DonutChart.values()[0].getDescription());
		for (int chart = 1; chart < DonutChart.values().length; chart++) {
			tree.addItem(DonutChart.values()[chart].getDescription());
			tree.setParent(DonutChart.values()[chart].getDescription(),
					DonutChart.values()[0].getDescription());
			tree.setChildrenAllowed(
					DonutChart.values()[chart].getDescription(), false);
		}
		tree.expandItemsRecursively(DonutChart.values()[0].getDescription());
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (DonutChart.fromString(chart)) {
		case BASIC:
			component = new BasicDonutChart();
			break;
		case DATA_LABELS_AND_LEGEND:
			component = new DonutChartWithDataLabelsAndLegend();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.DONUT.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (DonutChart chart : DonutChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
