package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum BarChart implements ChartType {

	DEFAULT("barCharts", "Bar charts"), //
	BASIC("basic", "Basic bar chart"), //
	HORIZONTAL_WITH_POINT_LABELS("horizontalWithPointLabels",
			"Horizontal with point labels"), //
	VERICAL_WITH_LEGEND("verticalWithLegend", "Vertical with legend");

	private final List<String> chart;

	private BarChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static BarChart fromString(String chart) {
		if (chart != null) {
			for (BarChart tempChart : BarChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
