package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum LineChart implements ChartType {

	DEFAULT("lineCharts", "Line charts"), //
	BASIC("basic", "Basic line chart"), //
	AXES("withAxes", "With axes"), //
	LINE_STYLE_OPTIONS("lineStyleOptions", "With line style options"), //
	MULTIPLE_AXIS("multipleAxis", "With multiple axis"), //
	HIGHLIGHTING_CURSOR_AND_TRENDLINE("highlightingCursorAndTrendline",
			"Highlighting, cursor and trendline");

	private final List<String> chart;

	private LineChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static LineChart fromString(String chart) {
		if (chart != null) {
			for (LineChart tempChart : LineChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
