package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum PieChart implements ChartType {

	DEFAULT("pieCharts", "Pie charts"), //
	BASIC("basic", "Basic pie chart"), //
	DATA_LABELS("dataLabels", "With data labels"), //
	LEGEND("legend", "With legend"), //
	EMPTY_SLICES("emptySlices", "With empty slices");

	private final List<String> chart;

	private PieChart(String... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<String> getValues() {
		return chart;
	}

	public static PieChart fromString(String chart) {
		if (chart != null) {
			for (PieChart tempChart : PieChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0);
	}

	@Override
	public String getDescription() {
		return chart.get(1);
	}

	@Override
	public String toString() {
		return getPath();
	}

}
