package org.dussan.dchartsdemo.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import javax.servlet.ServletContext;

public class ManifestReader {

	private static Properties manifestProperty = null;

	private static void initManifest(ServletContext context) {
		manifestProperty = new Properties();
		try {
			InputStream is = context
					.getResourceAsStream("/META-INF/MANIFEST.MF");
			InputStreamReader isReader = new InputStreamReader(is, "UTF-8");
			manifestProperty.load(new BufferedReader(isReader));
			isReader.close();
			is.close();
		} catch (IOException e) {
			manifestProperty = null;
		}
	}

	public static String getVersion(ServletContext context) {
		initManifest(context);
		if (manifestProperty != null) {
			return manifestProperty.getProperty("Application-Version");
		}
		return null;
	}

}
