/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.bubble.BasicBubbleChart;
import org.dussan.dchartsdemo.charts.bubble.BubbleChartWithTooltip;
import org.dussan.dchartsdemo.charts.bubble.BubbleChartWithTransparentBubbles;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.BubbleChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class BubbleCharts {

	public static void addMenus(final Tree tree) {
		String parent = BubbleChart.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent, BubbleChart.values()[0].getDescription());
		for (int chart = 1; chart < BubbleChart.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ BubbleChart.values()[chart].getPath();
			String itemValue = BubbleChart.values()[chart].getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (BubbleChart.fromString(chart)) {
		case BASIC:
			component = new BasicBubbleChart();
			break;
		case TRANSPARENT_BUBBLES:
			component = new BubbleChartWithTransparentBubbles();
			break;
		case WITH_TOOLTIP:
			component = new BubbleChartWithTooltip();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.BUBBLE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (BubbleChart chart : BubbleChart.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
