/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.events.BarChart;
import org.dussan.dchartsdemo.charts.events.BubbleChart;
import org.dussan.dchartsdemo.charts.events.DonutChart;
import org.dussan.dchartsdemo.charts.events.LineChart;
import org.dussan.dchartsdemo.charts.events.PieChart;
import org.dussan.dchartsdemo.charts.events.PyramidChart;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.ChartDataEvents;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class ChartEvents {

	public static void addMenus(final Tree tree) {
		String parent = ChartDataEvents.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent,
				ChartDataEvents.values()[0].getDescription());
		for (int chart = 1; chart < ChartDataEvents.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ ChartDataEvents.values()[chart].getPath();
			String itemValue = ChartDataEvents.values()[chart].getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (ChartDataEvents.fromString(chart)) {
		case BAR_CHART:
			component = new BarChart();
			break;
		case BUBBLE_CHART:
			component = new BubbleChart();
			break;
		case DONUT_CHART:
			component = new DonutChart();
			break;
		case LINE_CHART:
			component = new LineChart();
			break;
		case PIE_CHART:
			component = new PieChart();
			break;
		case PYRAMID_CHART:
			component = new PyramidChart();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String>> charts = new LinkedHashMap<String, Map<String, String>>();
			charts.put(ChartTypes.EVENTS.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String> getCharts() {
		Map<String, String> charts = new LinkedHashMap<String, String>();
		for (ChartDataEvents chart : ChartDataEvents.values()) {
			charts.put(chart.getPath(), chart.getDescription());
		}
		return charts;
	}

}
