/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.ui.context;

import java.util.Arrays;
import java.util.List;

import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.events.ChartData;
import org.vaadin.aceeditor.AceEditor;
import org.vaadin.aceeditor.gwt.ace.AceMode;
import org.vaadin.aceeditor.gwt.ace.AceTheme;

import com.vaadin.ui.AbstractLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window.Notification;

public abstract class ChartContext extends VerticalLayout {

	private static final long serialVersionUID = -4543823471416442797L;
	private boolean isAttached = false;
	private GridLayout mainLayout = null;

	public ChartContext() {
		setSizeFull();
		mainLayout = new GridLayout(2, 2);
		mainLayout.setSpacing(true);
		mainLayout.setStyleName("chartCode");
		mainLayout.setWidth(100, UNITS_PERCENTAGE);
		mainLayout.setHeight(null);
		addComponent(mainLayout);
	}

	abstract protected void init();

	protected void setChart(DCharts chart) {
		mainLayout.addComponent(chart, 0, 0, 1, 0);
		mainLayout.setComponentAlignment(chart, Alignment.TOP_CENTER);
		chart.setMarginBottom(8);
		chart.show();
	}

	protected void setJqPlotCode(Object text) {
		Panel panel = new Panel("jqPlot Code");
		panel.setSizeUndefined();
		panel.setScrollable(false);
		panel.setWidth(99, UNITS_PERCENTAGE);
		panel.setHeight(null);
		((AbstractLayout) panel.getContent()).setMargin(false);
		mainLayout.addComponent(panel, 0, 1);
		mainLayout.setComponentAlignment(panel, Alignment.BOTTOM_LEFT);

		AceEditor code = new AceEditor();
		panel.addComponent(code);
		code.setSizeFull();
		code.setWidth(100, UNITS_PERCENTAGE);
		code.setHeight(400, UNITS_PIXELS);
		code.setMode(AceMode.javascript);
		code.setTheme(AceTheme.eclipse);
		code.setFontSize("12px");
		code.setValue(text);
		code.setReadOnly(true);
	}

	protected void setDChatsCode(Object text) {
		Panel panel = new Panel("dCharts Code");
		panel.setSizeUndefined();
		panel.setScrollable(false);
		panel.setWidth(99, UNITS_PERCENTAGE);
		panel.setHeight(null);
		((AbstractLayout) panel.getContent()).setMargin(false);
		mainLayout.addComponent(panel, 1, 1);
		mainLayout.setComponentAlignment(panel, Alignment.BOTTOM_RIGHT);

		AceEditor code = new AceEditor();
		panel.addComponent(code);
		code.setSizeFull();
		code.setWidth(100, UNITS_PERCENTAGE);
		code.setHeight(400, UNITS_PIXELS);
		code.setMode(AceMode.java);
		code.setTheme(AceTheme.eclipse);
		code.setFontSize("12px");
		code.setValue(text);
		code.setReadOnly(true);
	}

	protected void showNotification(String event, ChartData chartData) {
		String caption = "<span style='color:#ff6600'>Event: " + event
				+ "</span>";
		StringBuilder description = new StringBuilder();
		description.append("<b>Chart id:</b> " + chartData.getChartId());

		if (chartData.getSeriesIndex() != null) {
			description.append("<br /><b>Series index:</b> "
					+ chartData.getSeriesIndex());
		}

		if (chartData.getPointIndex() != null) {
			description.append("<br /><b>Point index:</b> "
					+ chartData.getPointIndex());
		}

		if (chartData.getData() != null) {
			description.append("<br /><b>Chart data:</b> "
					+ Arrays.toString(chartData.getData()));
		}

		if (chartData.getOriginData() != null) {
			if (chartData.getOriginData() instanceof Object[]) {
				description
						.append("<br /><b>Origin data:</b> "
								+ Arrays.toString((Object[]) chartData
										.getOriginData()));
			} else {
				description.append("<br /><b>Origin data:</b> "
						+ chartData.getOriginData().toString());
			}
		}

		Notification notification = new Notification(caption,
				description.toString(), Notification.TYPE_TRAY_NOTIFICATION);
		notification.setDelayMsec(3000);
		notification.setHtmlContentAllowed(true);
		getWindow().showNotification(notification);
	}

	public static void addMenus(List<String> descriptions) {
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
			init();
		}
	}

}
