/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.line;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.LabelRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.AxesDefaults;
import org.dussan.vaadin.dcharts.options.Options;

import com.vaadin.ui.Layout;

public class LineChartWithAxes extends ChartContext {

	private static final long serialVersionUID = 8893541892104901370L;

	@Override
	protected void init() {
		AxesDefaults axesDefaults = new AxesDefaults()
				.setLabelRenderer(LabelRenderers.CANVAS);

		Axes axes = new Axes().addAxis(
				new XYaxis().setLabel("X Axis").setPad(0)).addAxis(
				new XYaxis(XYaxes.Y).setLabel("Y Axis"));

		Options options = new Options().setAxesDefaults(axesDefaults).setAxes(
				axes);

		DataSeries dataSeries = new DataSeries().add(3, 7, 9, 1, 4, 6, 8, 2, 5);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n" //
				+ "\tvar plot = $.jqplot ('chart2', [[3,7,9,1,4,6,8,2,5]], {\n"//
				+ "\t\ttitle: 'Plot With Options',\n"//
				+ "\t\taxesDefaults: {\n"//
				+ "\t\t\tlabelRenderer: $.jqplot.CanvasAxisLabelRenderer\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\tlabel: \"X Axis\",\n"//
				+ "\t\t\t\tpad: 0\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\tlabel: \"Y Axis\"\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("Title title = new Title(\"Plot With Options\");\n"//
				+ "\n"//
				+ "AxesDefaults axesDefaults = new AxesDefaults()\n"//
				+ "\t.setLabelRenderer(LabelRenderers.CANVAS);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setLabel(\"X Axis\")\n"//
				+ "\t\t\t.setPad(0))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setLabel(\"Y Axis\"));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setTitle(title)\n"//
				+ "\t.setAxesDefaults(axesDefaults)\n"//
				+ "\t.setAxes(axes);\n"//
				+ "\n"//
				+ "DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(3, 7, 9, 1, 4, 6, 8, 2, 5);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
