/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum ChartDataEvents implements ChartType {

	// definition: chart type, chart, is new
	DEFAULT("chartDataEvents", "Charts data events", false), //
	BAR_CHART("barChart", "Bar chart with events", true), //
	BUBBLE_CHART("bubbleChart", "Bubble chart with events", true), //
	DONUT_CHART("donutChart", "Donut chart with events", true), //
	LINE_CHART("lineChart", "Line chart with events", true), //
	PIE_CHART("pieChart", "Pie chart with events", true), //
	PYRAMID_CHART("pyramidChart", "Pyramid chart with events", true);

	private final List<Object> chart;

	private ChartDataEvents(Object... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<Object> getValues() {
		return chart;
	}

	public static ChartDataEvents fromString(String chart) {
		if (chart != null) {
			for (ChartDataEvents tempChart : ChartDataEvents.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0).toString();
	}

	@Override
	public String getDescription() {
		return chart.get(1).toString();
	}

	public boolean isNew() {
		return Boolean.parseBoolean(chart.get(2).toString());
	}

	@Override
	public String toString() {
		return getPath();
	}

}
