/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum LineChart implements ChartType {

	// definition: chart type, chart, is new
	DEFAULT("lineCharts", "Line charts", false), //
	BASIC("basic", "Basic line chart", false), //
	AXES("withAxes", "With axes", false), //
	LINE_STYLE_OPTIONS("lineStyleOptions", "With line style options", false), //
	MULTIPLE_AXIS("multipleAxis", "With multiple axis", false), //
	HIGHLIGHTING_CURSOR_AND_TRENDLINE("highlightingCursorAndTrendline",
			"Highlighting, cursor and trendline", false);

	private final List<Object> chart;

	private LineChart(Object... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<Object> getValues() {
		return chart;
	}

	public static LineChart fromString(String chart) {
		if (chart != null) {
			for (LineChart tempChart : LineChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0).toString();
	}

	@Override
	public String getDescription() {
		return chart.get(1).toString();
	}

	public boolean isNew() {
		return Boolean.parseBoolean(chart.get(2).toString());
	}

	@Override
	public String toString() {
		return getPath();
	}

}
