/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.types;

import java.util.Arrays;
import java.util.List;

import org.dussan.dchartsdemo.api.ChartType;

public enum PyramidChart implements ChartType {

	// definition: chart type, chart, is new
	DEFAULT("pyramidCharts", "Pyramid charts", false), //
	BASIC("basic", "Basic pyramid chart", false), //
	WITH_MIDDLE_AXIS("withMiddleAxis", "With middle axis", false), //
	WITH_TOOLTIP("withTooltip", "With tooltip", false);

	private final List<Object> chart;

	private PyramidChart(Object... charts) {
		this.chart = Arrays.asList(charts);
	}

	private List<Object> getValues() {
		return chart;
	}

	public static PyramidChart fromString(String chart) {
		if (chart != null) {
			for (PyramidChart tempChart : PyramidChart.values()) {
				if (tempChart.getValues().contains(chart)) {
					return tempChart;
				}
			}
		}
		return DEFAULT;
	}

	@Override
	public String getPath() {
		return chart.get(0).toString();
	}

	@Override
	public String getDescription() {
		return chart.get(1).toString();
	}

	public boolean isNew() {
		return Boolean.parseBoolean(chart.get(2).toString());
	}

	@Override
	public String toString() {
		return getPath();
	}

}
