/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.events;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.events.click.ChartDataClickEvent;
import org.dussan.vaadin.dcharts.events.click.ChartDataClickHandler;
import org.dussan.vaadin.dcharts.events.mouseenter.ChartDataMouseEnterEvent;
import org.dussan.vaadin.dcharts.events.mouseenter.ChartDataMouseEnterHandler;
import org.dussan.vaadin.dcharts.events.mouseleave.ChartDataMouseLeaveEvent;
import org.dussan.vaadin.dcharts.events.mouseleave.ChartDataMouseLeaveHandler;
import org.dussan.vaadin.dcharts.events.rightclick.ChartDataRightClickEvent;
import org.dussan.vaadin.dcharts.events.rightclick.ChartDataRightClickHandler;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;

import com.vaadin.ui.Layout;

public class BarChart extends ChartContext {

	private static final long serialVersionUID = -4745162253310857208L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().add(2, 6, 7, 10);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR);

		Axes axes = new Axes().addAxis(new XYaxis().setRenderer(
				AxisRenderers.CATEGORY).setTicks(
				new Ticks().add("a", "b", "c", "d")));

		Highlighter highlighter = new Highlighter().setShow(false);

		Options options = new Options().setCaptureRightClick(true)
				.setSeriesDefaults(seriesDefaults).setAxes(axes)
				.setHighlighter(highlighter);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		chart.setEnableChartDataMouseEnterEvent(true);
		chart.setEnableChartDataMouseLeaveEvent(true);
		chart.setEnableChartDataClickEvent(true);
		chart.setEnableChartDataRightClickEvent(true);

		chart.addHandler(new ChartDataMouseEnterHandler() {
			@Override
			public void onChartDataMouseEnter(ChartDataMouseEnterEvent event) {
				showNotification("CHART DATA MOUSE ENTER", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataMouseLeaveHandler() {
			@Override
			public void onChartDataMouseLeave(ChartDataMouseLeaveEvent event) {
				showNotification("CHART DATA MOUSE LEAVE", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataClickHandler() {
			@Override
			public void onChartDataClick(ChartDataClickEvent event) {
				showNotification("CHART DATA CLICK", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataRightClickHandler() {
			@Override
			public void onChartDataRightClick(ChartDataRightClickEvent event) {
				showNotification("CHART DATA RIGHT CLICK", event.getChartData());
			}
		});

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [2, 6, 7, 10];\n"//
				+ "\tvar ticks = ['a', 'b', 'c', 'd'];\n"//
				+ "\n"//
				+ "\tplot = $.jqplot('chart1', [s1], {\n"//
				+ "\t\tcaptureRightClick: true,\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer,\n"//
				+ "\t\t\t\tticks: ticks\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\thighlighter: { show: false }\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(2, 6, 7, 10);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY)\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(\"a\", \"b\", \"c\", \"d\")))\n"//
				+ "\n"//
				+ "Highlighter highlighter = new Highlighter()\n"//
				+ "\t.setShow(false);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setCaptureRightClick(true)\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setHighlighter(highlighter);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts();\n"//
				+ "\n"//
				+ "chart.setEnableChartDataMouseEnterEvent(true);\n"//
				+ "chart.setEnableChartDataMouseLeaveEvent(true);\n"//
				+ "chart.setEnableChartDataClickEvent(true);\n"//
				+ "chart.setEnableChartDataRightClickEvent(true);\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataMouseEnterHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataMouseEnter(ChartDataMouseEnterEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA MOUSE ENTER\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataMouseLeaveHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataMouseLeave(ChartDataMouseLeaveEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA MOUSE LEAVE\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataClickHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataClick(ChartDataClickEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA CLICK\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataRightClickHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataRightClick(ChartDataRightClickEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA RIGHT CLICK\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
