/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.ohlc;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.renderers.tick.AxisTickRenderer;

import com.vaadin.ui.Layout;

public class BasicOhlcChart extends ChartContext {

	private static final long serialVersionUID = 3495125594201148086L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries()
				.add("04/13/2009", 120.01, 124.25, 115.76, 123.42, "s")
				.add("04/20/2009", 121.73, 127.2, 118.6, 123.9, "t")
				.add("04/27/2009", 122.9, 127.95, 122.66, 127.24, "r")
				.add("05/04/2009", 128.24, 133.5, 126.26, 129.19, "a")
				.add("05/11/2009", 127.37, 130.96, 119.38, 122.42, "h")
				.add("05/18/2009", 123.73, 129.31, 121.57, 122.5, "c")
				.add("05/26/2009", 124.76, 135.9, 124.55, 135.81, "_")
				.add("06/01/2009", 136.47, 146.4, 136, 144.67, "t")
				.add("06/08/2009", 143.82, 144.56, 136.04, 136.97, "o")
				.add("06/15/2009", 136.01, 139.5, 134.53, 139.48, "l")
				.add("06/22/2009", 140.67, 143.56, 132.88, 142.44, "p")
				.add("06/29/2009", 143.46, 144.66, 139.79, 140.02, "q")
				.add("07/06/2009", 138.7, 139.68, 135.18, 135.4, "j");

		Axes axes = new Axes().addAxis(
				new XYaxis().setRenderer(AxisRenderers.DATE)).addAxis(
				new XYaxis(XYaxes.Y).setTickOptions(new AxisTickRenderer()
						.setPrefix("$")));

		Series series = new Series().addSeries(new XYseries()
				.setRenderer(SeriesRenderers.OHLC));

		Options options = new Options().setAxes(axes).setSeries(series);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		chart.setMarginRight(20);
		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar ohlc = [['04/13/2009', 120.01, 124.25, 115.76, 123.42, 's'],\n"//
				+ "\t\t['04/20/2009', 121.73, 127.2, 118.6, 123.9, 't'],\n"//
				+ "\t\t['04/27/2009', 122.9, 127.95, 122.66, 127.24, 'r'],\n"//
				+ "\t\t['05/04/2009', 128.24, 133.5, 126.26, 129.19, 'a'],\n"//
				+ "\t\t['05/11/2009', 127.37, 130.96, 119.38, 122.42, 'h'],\n"//
				+ "\t\t['05/18/2009', 123.73, 129.31, 121.57, 122.5, 'c'],\n"//
				+ "\t\t['05/26/2009', 124.76, 135.9, 124.55, 135.81, '_'],\n"//
				+ "\t\t['06/01/2009', 136.47, 146.4, 136, 144.67, 't'],\n"//
				+ "\t\t['06/08/2009', 143.82, 144.56, 136.04, 136.97, 'o'],\n"//
				+ "\t\t['06/15/2009', 136.01, 139.5, 134.53, 139.48, 'l'],\n"//
				+ "\t\t['06/22/2009', 140.67, 143.56, 132.88, 142.44, 'p'],\n"//
				+ "\t\t['06/29/2009', 143.46, 144.66, 139.79, 140.02, 'q'],\n"//
				+ "\t\t['07/06/2009', 138.7, 139.68, 135.18, 135.4, 'j']];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('ohlc', [ohlc], {\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer:$.jqplot.DateAxisRenderer\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\ttickOptions:{prefix: '$'}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\tseries: [{renderer: $.jqplot.OHLCRenderer, rendererOptions:{}}]\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"04/13/2009\", 120.01, 124.25, 115.76, 123.42, \"s\")\n"// ;
				+ "\t.add(\"04/20/2009\", 121.73, 127.2, 118.6, 123.9, \"t\")\n"//
				+ "\t.add(\"04/27/2009\", 122.9, 127.95, 122.66, 127.24, \"r\")\n"//
				+ "\t.add(\"05/04/2009\", 128.24, 133.5, 126.26, 129.19, \"a\")\n"//
				+ "\t.add(\"05/11/2009\", 127.37, 130.96, 119.38, 122.42, \"h\")\n"//
				+ "\t.add(\"05/18/2009\", 123.73, 129.31, 121.57, 122.5, \"c\")\n"//
				+ "\t.add(\"05/26/2009\", 124.76, 135.9, 124.55, 135.81, \"_\")\n"//
				+ "\t.add(\"06/01/2009\", 136.47, 146.4, 136, 144.67, \"t\")\n"//
				+ "\t.add(\"06/08/2009\", 143.82, 144.56, 136.04, 136.97, \"o\")\n"//
				+ "\t.add(\"06/15/2009\", 136.01, 139.5, 134.53, 139.48, \"l\")\n"//
				+ "\t.add(\"06/22/2009\", 140.67, 143.56, 132.88, 142.44, \"p\")\n"//
				+ "\t.add(\"06/29/2009\", 143.46, 144.66, 139.79, 140.02, \"q\")\n"//
				+ "\t.add(\"07/06/2009\", 138.7, 139.68, 135.18, 135.4, \"j\");\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.DATE))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setTickOptions(\n"//
				+ "\t\t\t\tnew AxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setPrefix(\"$\")));\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(new XYseries()\n"//
				+ "\t\t.setRenderer(SeriesRenderers.OHLC));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setSeries(series);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
