/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.summary;

import java.util.Map;
import java.util.Map.Entry;

import org.dussan.dchartsdemo.DChartsDemoWindow;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.event.MouseEvents.ClickEvent;
import com.vaadin.event.MouseEvents.ClickListener;
import com.vaadin.terminal.ThemeResource;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;

public class ChartsSummary extends VerticalLayout {

	private static final long serialVersionUID = 2732668125860378592L;
	private boolean isAttached = false;
	private Map<String, Map<String, String[]>> charts = null;

	public ChartsSummary(Map<String, Map<String, String[]>> charts) {
		this.charts = charts;
	}

	private void init() {
		setSizeUndefined();
		setWidth(100, UNITS_PERCENTAGE);

		for (Entry<String, Map<String, String[]>> chart : charts.entrySet()) {
			String chartType = chart.getKey();
			Map<String, String[]> charts = chart.getValue();

			VerticalLayout chartsLayout = new VerticalLayout();
			chartsLayout.setSizeUndefined();
			chartsLayout.setWidth(100, UNITS_PERCENTAGE);
			chartsLayout.setStyleName("chartsLayout");
			addComponent(chartsLayout);

			Label chartTypeLabel = new Label();
			chartTypeLabel.setWidth(100, UNITS_PERCENTAGE);
			chartTypeLabel.setStyleName("chartTypeLabel");
			chartsLayout.addComponent(chartTypeLabel);

			CssLayout cssLayout = new CssLayout();
			cssLayout.setSizeUndefined();
			cssLayout.setWidth(100, UNITS_PERCENTAGE);
			chartsLayout.addComponent(cssLayout);

			for (Entry<String, String[]> tempChart : charts.entrySet()) {
				String chartName = tempChart.getKey();
				String chartDescription = tempChart.getValue()[0];
				String chartLongDescription = tempChart.getValue()[1];
				if (chartType.equals(chartName)) {
					chartTypeLabel.setValue(chartDescription);
				} else {
					VerticalLayout chartLayout = new VerticalLayout();
					chartLayout.setSizeUndefined();
					chartLayout.setStyleName("chartLayout");
					cssLayout.addComponent(chartLayout);

					Embedded chartImage = new Embedded(null, new ThemeResource(
							"images/" + chartType + "/" + chartName + ".png"));
					chartImage.setStyleName("chartImage");
					chartImage.setDebugId(chartType + "/" + chartName);
					chartLayout.addComponent(chartImage);

					Label chartLabel = new Label(chartLongDescription);
					chartLabel.setStyleName("chartLabel");
					if (ChartsTree.isNewChart(chartType, chartName)) {
						chartLabel.setContentMode(Label.CONTENT_XHTML);
						chartLabel.setValue("<span class='new-chart'>"
								+ chartLongDescription + "</span>");
					}
					chartLayout.addComponent(chartLabel);
					chartImage.addListener(new ClickListener() {
						private static final long serialVersionUID = 301424711026984913L;

						@Override
						public void click(ClickEvent event) {
							String fragment = event.getComponent().getDebugId();
							((DChartsDemoWindow) getApplication()
									.getMainWindow()).getUriTool().setFragment(
									fragment);
						};
					});
				}
			}
		}
	}

	@Override
	public void attach() {
		if (!isAttached) {
			isAttached = true;
			init();
		}
	}

}
