/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.waterfall;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.PointLabels;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.Yaxes;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.TickRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.options.Title;
import org.dussan.vaadin.dcharts.renderers.series.BarRenderer;
import org.dussan.vaadin.dcharts.renderers.tick.CanvasAxisTickRenderer;

import com.vaadin.ui.Layout;

public class BasicWaterfallChart extends ChartContext {

	private static final long serialVersionUID = 7022040354534715437L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries()
				.add(14, 3, 4, -3, 5, 2, -3, -7);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR)
				.setRendererOptions(
						new BarRenderer().setWaterfall(true).setVaryBarColor(
								true))
				.setPointLabels(new PointLabels().setHideZeros(true))
				.setYaxis(Yaxes.Y2);

		Axes axes = new Axes().addAxis(
				new XYaxis()
						.setRenderer(AxisRenderers.CATEGORY)
						.setTicks(
								new Ticks().add("2008", "Apricots", "Tomatoes",
										"Potatoes", "Rhubarb", "Squash",
										"Grapes", "Peanuts", "2009"))
						.setTickRenderer(TickRenderers.CANVAS)
						.setTickOptions(
								new CanvasAxisTickRenderer().setAngle(-90)
										.setFontSize("10pt").setShowMark(false)
										.setShowGridline(false))).addAxis(
				new XYaxis(XYaxes.Y2).setMin(0).setTickInterval(5));

		Title title = new Title("Crop Yield Charnge, 2008 to 2009");

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setAxes(axes).setTitle(title);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [14, 3, 4, -3, 5, 2, -3, -7];\n"//
				+ "\tvar ticks = ['2008', 'Apricots', 'Tomatoes', 'Potatoes', 'Rhubarb', 'Squash', 'Grapes', 'Peanuts', '2009'];\n"//
				+ "\n"//
				+ "\tplot = $.jqplot('chart1', [s1], {\n"//
				+ "\t\ttitle: 'Crop Yield Charnge, 2008 to 2009',\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t\trendererOptions:{\n"//
				+ "\t\t\t\twaterfall:true,\n"//
				+ "\t\t\t\tvaryBarColor: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tpointLabels: {\n"//
				+ "\t\t\t\thideZeros: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tyaxis:'y2axis'\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer,\n"//
				+ "\t\t\t\tticks: ticks,\n"//
				+ "\t\t\t\ttickRenderer: $.jqplot.CanvasAxisTickRenderer,\n"//
				+ "\t\t\t\ttickOptions: {\n"//
				+ "\t\t\t\t\tangle: -90,\n"//
				+ "\t\t\t\t\tfontSize: '10pt',\n"//
				+ "\t\t\t\t\tshowMark: false,\n"//
				+ "\t\t\t\t\tshowGridline: false\n"//
				+ "\t\t\t\t}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\ty2axis: {\n"//
				+ "\t\t\t\tmin: 0,\n"//
				+ "\t\t\t\ttickInterval: 5\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(14, 3, 4, -3, 5, 2, -3, -7);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew BarRenderer()\n"//
				+ "\t\t\t.setWaterfall(true)\n"//
				+ "\t\t\t.setVaryBarColor(true))\n"//
				+ "\t.setPointLabels(\n"//
				+ "\t\tnew PointLabels()\n"//
				+ "\t\t\t.setHideZeros(true))\n"//
				+ "\t.setYaxis(Yaxes.Y2);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY)\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(\"2008\", \"Apricots\", \"Tomatoes\", \"Potatoes\", \"Rhubarb\", \"Squash\", \"Grapes\", \"Peanuts\", \"2009\")))\n"//
				+ "\t\t\t.setTickRenderer(TickRenderers.CANVAS)\n"//
				+ "\t\t\t.setTickOptions(\n"//
				+ "\t\t\t\tnew CanvasAxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setAngle(-90)\n"//
				+ "\t\t\t\t\t.setFontSize(\"10pt\")\n"//
				+ "\t\t\t\t\t.setShowMark(false)\n"//
				+ "\t\t\t\t\t.setShowGridline(false)))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y2)\n"//
				+ "\t\t\t.setMin(0)\n"//
				+ "\t\t\t.setTickInterval(5));\n"//
				+ "\n"//
				+ "Title title = new Title(\"Crop Yield Charnge, 2008 to 2009\");\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setTitle(title);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setTitle(\"Crop Yield Charnge, 2008 to 2009\")\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
