/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo;

import org.dussan.dchartsdemo.ui.Header;
import org.dussan.dchartsdemo.ui.UriTool;
import org.dussan.dchartsdemo.ui.context.ContextPanel;
import org.dussan.dchartsdemo.ui.tree.TreePanel;

import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Window;

public class DChartsDemoWindow extends Window {

	private static final long serialVersionUID = 7038630410919798590L;
	private boolean isAttached = false;
	private UriTool uriTool = null;

	public DChartsDemoWindow(String title) {
		super.setCaption(title);
		init();
	}

	private void init() {
		GridLayout main = new GridLayout(2, 2);
		main.setStyleName("demo");
		main.setSizeFull();
		main.setSpacing(false);
		main.setRowExpandRatio(1, 1.0f);
		main.setColumnExpandRatio(1, 1.0f);
		setContent(main);

		main.addComponent(new Header(), 0, 0, 1, 0);
		main.addComponent(new TreePanel(), 0, 1);
		main.addComponent(new ContextPanel(), 1, 1);

		uriTool = new UriTool();
		addComponent(uriTool);
	}

	public UriTool getUriTool() {
		return uriTool;
	}

	@Override
	public void attach() {
		super.attach();
		if (!isAttached) {
			isAttached = true;
		}
	}

}
