/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.donut.BasicDonutChart;
import org.dussan.dchartsdemo.charts.donut.DonutChartWithDataLabelsAndLegend;
import org.dussan.dchartsdemo.charts.donut.DonutChartWithTooltip;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.DonutChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class DonutCharts {

	public static void addMenus(final Tree tree) {
		String parent = DonutChart.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent, DonutChart.values()[0].getDescription());
		for (int chart = 1; chart < DonutChart.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ DonutChart.values()[chart].getPath();
			String itemValue = DonutChart.values()[chart].getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (DonutChart.fromString(chart)) {
		case BASIC:
			component = new BasicDonutChart();
			break;
		case DATA_LABELS_AND_LEGEND:
			component = new DonutChartWithDataLabelsAndLegend();
			break;
		case WITH_TOOLTIP:
			component = new DonutChartWithTooltip();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String[]>> charts = new LinkedHashMap<String, Map<String, String[]>>();
			charts.put(ChartTypes.DONUT.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String[]> getCharts() {
		Map<String, String[]> charts = new LinkedHashMap<String, String[]>();
		for (DonutChart chart : DonutChart.values()) {
			charts.put(chart.getPath(), new String[] { chart.getDescription(),
					chart.getLongDescription() });
		}
		return charts;
	}

}
