/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.pyramid;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYseries;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.PyramidSides;
import org.dussan.vaadin.dcharts.metadata.Yaxes;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.Series;
import org.dussan.vaadin.dcharts.renderers.series.PyramidRenderer;

import com.vaadin.ui.Layout;

public class BasicPyramidChart extends ChartContext {

	private static final long serialVersionUID = -8552411270655149000L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().add(0.635441, 1.066868,
				0.889602, 0.816883, 1.016458, 0.916705, 0.79569, 0.970443,
				1.046451, 1.335686).add(0.767078, 0.679554, 1.064493, 0.915063,
				0.860792, 0.785728, 0.892471, 0.687886, 1.055313, 0.921839);

		Series series = new Series().addSeries(
				new XYseries().setRendererOptions(new PyramidRenderer()
						.setSide(PyramidSides.LEFT))).addSeries(
				new XYseries(Yaxes.Y2).setRendererOptions(new PyramidRenderer()
						.setSide(PyramidSides.RIGHT)));

		Options options = new Options().setSeries(series);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar male = [0.635441, 1.066868, 0.889602, 0.816883, 1.016458, 0.916705, 0.79569, 0.970443, 1.046451, 1.335686];\n"//
				+ "\tvar female = [0.767078, 0.679554, 1.064493, 0.915063, 0.860792, 0.785728, 0.892471, 0.687886, 1.055313, 0.921839];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('pyramid', [male, female], {\n"//
				+ "\t\tseries: [\n"//
				+ "\t\t\t{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"yaxis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"left\"}\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\t{\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trenderer: $.jqplot.PyramidRenderer,\n"//
				+ "\t\t\t\txaxis: \"xaxis\",\n"//
				+ "\t\t\t\tyaxis: \"y2axis\",\n"//
				+ "\t\t\t\trendererOptions: {side: \"right\"}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t]\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(0.635441, 1.066868, 0.889602, 0.816883, 1.016458, 0.916705, 0.79569, 0.970443, 1.046451, 1.335686)\n"//
				+ "\t.add(0.767078, 0.679554, 1.064493, 0.915063, 0.860792, 0.785728, 0.892471, 0.687886, 1.055313, 0.921839);\n"//
				+ "\n"//
				+ "Series series = new Series()\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries()\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.LEFT)))\n"//
				+ "\t.addSeries(\n"//
				+ "\t\tnew XYseries(Yaxes.Y2)\n"//
				+ "\t\t\t.setRendererOptions(\n"//
				+ "\t\t\t\tnew PyramidRenderer()\n"//
				+ "\t\t\t\t\t.setSide(PyramidSides.RIGHT)));\n"//
				+ "\n"//
				+ "Options options = new Options().setSeries(series);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
