/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.pie.BasicPieChart;
import org.dussan.dchartsdemo.charts.pie.PieChartWithDataLabels;
import org.dussan.dchartsdemo.charts.pie.PieChartWithEmptySlices;
import org.dussan.dchartsdemo.charts.pie.PieChartWithLegend;
import org.dussan.dchartsdemo.charts.pie.PieChartWithTooltip;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.PieChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class PieCharts {

	public static void addMenus(final Tree tree) {
		String parent = PieChart.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent, PieChart.values()[0].getDescription());
		for (int chart = 1; chart < PieChart.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ PieChart.values()[chart].getPath();
			String itemValue = PieChart.values()[chart].getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (PieChart.fromString(chart)) {
		case BASIC:
			component = new BasicPieChart();
			break;
		case DATA_LABELS:
			component = new PieChartWithDataLabels();
			break;
		case EMPTY_SLICES:
			component = new PieChartWithEmptySlices();
			break;
		case LEGEND:
			component = new PieChartWithLegend();
			break;
		case WITH_TOOLTIP:
			component = new PieChartWithTooltip();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String[]>> charts = new LinkedHashMap<String, Map<String, String[]>>();
			charts.put(ChartTypes.PIE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String[]> getCharts() {
		Map<String, String[]> charts = new LinkedHashMap<String, String[]>();
		for (PieChart chart : PieChart.values()) {
			charts.put(chart.getPath(), new String[] { chart.getDescription(),
					chart.getLongDescription() });
		}
		return charts;
	}

}
