/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.events;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.events.click.ChartDataClickEvent;
import org.dussan.vaadin.dcharts.events.click.ChartDataClickHandler;
import org.dussan.vaadin.dcharts.events.mouseenter.ChartDataMouseEnterEvent;
import org.dussan.vaadin.dcharts.events.mouseenter.ChartDataMouseEnterHandler;
import org.dussan.vaadin.dcharts.events.mouseleave.ChartDataMouseLeaveEvent;
import org.dussan.vaadin.dcharts.events.mouseleave.ChartDataMouseLeaveHandler;
import org.dussan.vaadin.dcharts.events.rightclick.ChartDataRightClickEvent;
import org.dussan.vaadin.dcharts.events.rightclick.ChartDataRightClickHandler;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.series.DonutRenderer;

import com.vaadin.ui.Layout;

public class DonutChart extends ChartContext {

	private static final long serialVersionUID = -5700371354122558691L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries();
		dataSeries.newSeries();
		dataSeries.add("a", 6).add("b", 8).add("c", 14).add("d", 20);
		dataSeries.newSeries();
		dataSeries.add("a", 8).add("b", 12).add("c", 6).add("d", 9);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.DONUT).setRendererOptions(
				new DonutRenderer().setSliceMargin(3).setStartAngle(-90));

		Options options = new Options().setCaptureRightClick(true)
				.setSeriesDefaults(seriesDefaults);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		chart.setEnableChartDataMouseEnterEvent(true);
		chart.setEnableChartDataMouseLeaveEvent(true);
		chart.setEnableChartDataClickEvent(true);
		chart.setEnableChartDataRightClickEvent(true);

		chart.addHandler(new ChartDataMouseEnterHandler() {
			@Override
			public void onChartDataMouseEnter(ChartDataMouseEnterEvent event) {
				showNotification("CHART DATA MOUSE ENTER", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataMouseLeaveHandler() {
			@Override
			public void onChartDataMouseLeave(ChartDataMouseLeaveEvent event) {
				showNotification("CHART DATA MOUSE LEAVE", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataClickHandler() {
			@Override
			public void onChartDataClick(ChartDataClickEvent event) {
				showNotification("CHART DATA CLICK", event.getChartData());
			}
		});

		chart.addHandler(new ChartDataRightClickHandler() {
			@Override
			public void onChartDataRightClick(ChartDataRightClickEvent event) {
				showNotification("CHART DATA RIGHT CLICK", event.getChartData());
			}
		});

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [['a',6], ['b',8], ['c',14], ['d',20]];\n"//
				+ "\tvar s2 = [['a', 8], ['b', 12], ['c', 6], ['d', 9]];\n"//
				+ "\n"//
				+ "\tvar plot = $.jqplot('donut', [s1, s2], {\n"//
				+ "\t\tcaptureRightClick: true,\n"//
				+ "\t\tseriesDefaults: {\n"//
				+ "\t\t\trenderer:$.jqplot.DonutRenderer,\n"//
				+ "\t\t\trendererOptions:{\n"//
				+ "\t\t\t\tsliceMargin: 3,\n"//
				+ "\t\t\t\tstartAngle: -90\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries();\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"a\", 6)\n"//
				+ "\t.add(\"b\", 8)\n"//
				+ "\t.add(\"c\", 14)\n"//
				+ "\t.add(\"d\", 20);\n"//
				+ "dataSeries.newSeries()\n"//
				+ "\t.add(\"a\", 8)\n"//
				+ "\t.add(\"b\", 12)\n"//
				+ "\t.add(\"c\", 6)\n"//
				+ "\t.add(\"d\", 9);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.DONUT)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew DonutRenderer()\n"//
				+ "\t\t\t.setSliceMargin(3)\n"//
				+ "\t\t\t.setStartAngle(-90));\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setCaptureRightClick(true)\n"//
				+ "\t.setSeriesDefaults(seriesDefaults);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts();\n"//
				+ "\n"//
				+ "chart.setEnableChartDataMouseEnterEvent(true);\n"//
				+ "chart.setEnableChartDataMouseLeaveEvent(true);\n"//
				+ "chart.setEnableChartDataClickEvent(true);\n"//
				+ "chart.setEnableChartDataRightClickEvent(true);\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataMouseEnterHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataMouseEnter(ChartDataMouseEnterEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA MOUSE ENTER\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataMouseLeaveHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataMouseLeave(ChartDataMouseLeaveEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA MOUSE LEAVE\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataClickHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataClick(ChartDataClickEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA CLICK\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.addHandler(new ChartDataRightClickHandler() {\n"//
				+ "\t@Override\n"//
				+ "\tpublic void onChartDataRightClick(ChartDataRightClickEvent event) {\n"//
				+ "\t\tshowNotification(\"CHART DATA RIGHT CLICK\", event.getChartData());\n"//
				+ "\t}\n"//
				+ "});\n"//
				+ "\n"//
				+ "chart.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
