/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.line;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.Trendline;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.TooltipAxes;
import org.dussan.vaadin.dcharts.metadata.XYaxes;
import org.dussan.vaadin.dcharts.metadata.locations.TooltipLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.Cursor;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.tick.AxisTickRenderer;

import com.vaadin.ui.Layout;

public class LineChartWithHighlightingCursorAndTrendline extends ChartContext {

	private static final long serialVersionUID = 2580645590551396982L;

	@Override
	protected void init() {
		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setMarginRight(20);

		DataSeries dataSeries = new DataSeries().newSeries()
				.add("23-May-08", 1).add("24-May-08", 4).add("25-May-08", 2)
				.add("26-May-08", 6);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setTrendline(new Trendline().setShow(true));

		Axes axes = new Axes().addAxis(
				new XYaxis()
						.setRenderer(AxisRenderers.DATE)
						.setTickOptions(
								new AxisTickRenderer()
										.setFormatString("%#m/%#d/%y"))
						.setNumberTicks(4)).addAxis(
				new XYaxis(XYaxes.Y).setTickOptions(new AxisTickRenderer()
						.setFormatString("$%.2f")));

		Highlighter highlighter = new Highlighter()
				.setShow(true)
				.setSizeAdjust(10)
				.setTooltipLocation(TooltipLocations.NORTH)
				.setTooltipAxes(TooltipAxes.Y)
				.setTooltipFormatString(
						"<b><i><span style=\"color:red;\">hello</span></i></b> %.2f")
				.setUseAxesFormatters(false);

		Cursor cursor = new Cursor().setShow(true);

		Options options = new Options().addOption(seriesDefaults)
				.addOption(axes).addOption(highlighter).addOption(cursor);

		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\n"//
				+ "\t$.jqplot.config.enablePlugins = true;\n"//
				+ "\n"//
				+ "\ts1 = [['23-May-08',1],['24-May-08',4],['25-May-08',2],['26-May-08',6]];\n"//
				+ "\n"//
				+ "\tplot = $.jqplot('chart',[s1],{\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.DateAxisRenderer,\n"//
				+ "\t\t\t\t\ttickOptions: {\n"//
				+ "\t\t\t\t\t\tformatString: '%#m/%#d/%y'\n"//
				+ "\t\t\t\t\t},\n"//
				+ "\t\t\t\t\tnumberTicks: 4\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\tyaxis: {\n"//
				+ "\t\t\t\ttickOptions: {\n"//
				+ "\t\t\t\t\tformatString: '$%.2f'\n"//
				+ "\t\t\t\t}\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\thighlighter: {\n"//
				+ "\t\t\tsizeAdjust: 10,\n"//
				+ "\t\t\ttooltipLocation: 'n',\n"//
				+ "\t\t\ttooltipAxes: 'y',\n"//
				+ "\t\t\ttooltipFormatString: '<b><i><span style=\"color:red;\">hello</span></i></b> %.2f',\n"//
				+ "\t\t\tuseAxesFormatters: false\n"//
				+ "\t\t},\n"//
				+ "\t\tcursor: {\n"//
				+ "\t\t\tshow: true\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"23-May-08\", 1)\n"//
				+ "\t.add(\"24-May-08\", 4)\n"//
				+ "\t.add(\"25-May-08\", 2)\n"//
				+ "\t.add(\"26-May-08\", 6);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setTrendline(\n"//
				+ "\t\tnew Trendline()\n"//
				+ "\t\t\t.setShow(true));\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.DATE)\n"//
				+ "\t\t\t.setTickOptions(\n"//
				+ "\t\t\t\tnew AxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setFormatString(\"%#m/%#d/%y\"))\n"//
				+ "\t\t\t\t\t.setNumberTicks(4))\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis(XYaxes.Y)\n"//
				+ "\t\t\t.setTickOptions(\n"//
				+ "\t\t\t\tnew AxisTickRenderer()\n"//
				+ "\t\t\t\t\t.setFormatString(\"$%.2f\")));\n"//
				+ "\n"//
				+ "Highlighter highlighter = new Highlighter()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setSizeAdjust(10)\n"//
				+ "\t.setTooltipLocation(TooltipLocations.NORTH)\n"//
				+ "\t.setTooltipAxes(TooltipAxes.Y)\n"//
				+ "\t.setTooltipFormatString(\"<b><i><span style='color:red;'>hello</span></i></b> %.2f\")\n"//
				+ "\t.setUseAxesFormatters(false);\n"//
				+ "\n"//
				+ "Cursor cursor = new Cursor()\n"//
				+ "\t.setShow(true);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.addOption(seriesDefaults)\n"//
				+ "\t.addOption(axes)\n"//
				+ "\t.addOption(highlighter)\n"//
				+ "\t.addOption(cursor);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}
}
