/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.pie;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.metadata.locations.LegendLocations;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Legend;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;
import org.dussan.vaadin.dcharts.renderers.legend.EnhancedLegendRenderer;
import org.dussan.vaadin.dcharts.renderers.series.PieRenderer;

import com.vaadin.ui.Layout;

public class PieChartWithLegend extends ChartContext {

	private static final long serialVersionUID = -6438427915462348751L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().newSeries().add("none", 23)
				.add("error", 0).add("click", 5).add("impression", 25);

		SeriesDefaults seriesDefaults = new SeriesDefaults().setRenderer(
				SeriesRenderers.PIE).setRendererOptions(
				new PieRenderer().setShowDataLabels(true));

		Legend legend = new Legend()
				.setShow(true)
				.setRendererOptions(
						new EnhancedLegendRenderer().setNumberRows(1))
				.setLocation(LegendLocations.SOUTH);

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setLegend(legend);

		DCharts chart = new DCharts();
		chart.setWidth(450, Layout.UNITS_PIXELS);
		chart.setHeight(300, Layout.UNITS_PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar plot = $.jqplot('pie', [[[\"none\",23],[\"error\",0],[\"click\",5],[\"impression\",25]]], {\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.PieRenderer,\n"//
				+ "\t\t\trendererOptions: {\n"//
				+ "\t\t\t\tshowDataLabels: true\n"//
				+ "\t\t\t},\n"//
				+ "\t\t\tlegend: {\n"//
				+ "\t\t\t\tshow: true,\n"//
				+ "\t\t\t\trendererOptions: {\n"//
				+ "\t\t\t\t\tnumberRows: 1\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\t\tlocation: 's'\n"//
				+ "\t\t\t}\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.newSeries()\n"//
				+ "\t.add(\"none\", 23)\n"//
				+ "\t.add(\"error\", 0)\n"//
				+ "\t.add(\"click\", 5)\n"//
				+ "\t.add(\"impression\", 25);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.PIE)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew PieRenderer()\n"//
				+ "\t\t\t.setShowDataLabels(true));\n"//
				+ "\n"//
				+ "Legend legend = new Legend()\n"//
				+ "\t.setShow(true)\n"//
				+ "\t.setRendererOptions(\n"//
				+ "\t\tnew EnhancedLegendRenderer()\n"//
				+ "\t\t\t.setNumberRows(1))\n"//
				+ "\t.setLocation(LegendLocations.SOUTH);\n"//
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setLegend(legend);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
