/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.additional.ChartWithCanvasOverlay;
import org.dussan.dchartsdemo.charts.additional.ChartZoomOnLegendClickEvent;
import org.dussan.dchartsdemo.charts.additional.ChartsPlacedInTabs;
import org.dussan.dchartsdemo.charts.additional.HideShowAreaChart;
import org.dussan.dchartsdemo.charts.additional.MoreChartsInSameLayout;
import org.dussan.dchartsdemo.charts.additional.SaveChartImage;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.AdditionalOptions;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class AdditionalCharts {

	public static void addMenus(final Tree tree) {
		String parent = AdditionalOptions.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent,
				AdditionalOptions.values()[0].getDescription());
		for (int chart = 1; chart < AdditionalOptions.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ AdditionalOptions.values()[chart].getPath();
			String itemValue = AdditionalOptions.values()[chart]
					.getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (AdditionalOptions.fromString(chart)) {
		case CHARTS_PLACED_IN_TABS:
			component = new ChartsPlacedInTabs();
			break;
		case HIDE_SHOW_AREA:
			component = new HideShowAreaChart();
			break;
		case MORE_CHARTS_IN_SAME_LAYOUT:
			component = new MoreChartsInSameLayout();
			break;
		case SAVE_CHART_IMAGE:
			component = new SaveChartImage();
			break;
		case CHART_WITH_CANVAS_OVERLAY:
			component = new ChartWithCanvasOverlay();
			break;
		case CHART_ZOOM_ON_LEGEND_CLICK_EVENT:
			component = new ChartZoomOnLegendClickEvent();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String[]>> charts = new LinkedHashMap<String, Map<String, String[]>>();
			charts.put(ChartTypes.ADDITIONAL.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String[]> getCharts() {
		Map<String, String[]> charts = new LinkedHashMap<String, String[]>();
		for (AdditionalOptions chart : AdditionalOptions.values()) {
			charts.put(chart.getPath(), new String[] { chart.getDescription(),
					chart.getLongDescription() });
		}
		return charts;
	}

}
