/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts;

import java.util.LinkedHashMap;
import java.util.Map;

import org.dussan.dchartsdemo.charts.metergauge.BasicMeterGaugeChart;
import org.dussan.dchartsdemo.charts.metergauge.MeterGaugeChartWithTickLabels;
import org.dussan.dchartsdemo.charts.metergauge.MeterGaugeChartWithoutTickLabels;
import org.dussan.dchartsdemo.charts.summary.ChartsSummary;
import org.dussan.dchartsdemo.charts.types.MeterGaugeChart;
import org.dussan.dchartsdemo.ui.tree.ChartTypes;
import org.dussan.dchartsdemo.ui.tree.ChartsTree;

import com.vaadin.ui.Component;
import com.vaadin.ui.Tree;

public class MeterGaugeCharts {

	public static void addMenus(final Tree tree) {
		String parent = MeterGaugeChart.values()[0].getPath();
		tree.addItem(parent);
		tree.setItemCaption(parent,
				MeterGaugeChart.values()[0].getDescription());
		for (int chart = 1; chart < MeterGaugeChart.values().length; chart++) {
			String item = parent + ChartsTree.PATH_DELIMITER
					+ MeterGaugeChart.values()[chart].getPath();
			String itemValue = MeterGaugeChart.values()[chart].getDescription();
			tree.addItem(item);
			tree.setItemCaption(item, itemValue);
			tree.setParent(item, parent);
			tree.setChildrenAllowed(item, false);
		}
		tree.expandItemsRecursively(parent);
	}

	public static Component processChart(String chart) {
		Component component = null;
		switch (MeterGaugeChart.fromString(chart)) {
		case BASIC:
			component = new BasicMeterGaugeChart();
			break;
		case WITH_TICK_LABELS:
			component = new MeterGaugeChartWithTickLabels();
			break;
		case WITHOUT_TICK_LABELS:
			component = new MeterGaugeChartWithoutTickLabels();
			break;
		case DEFAULT:
		default:
			Map<String, Map<String, String[]>> charts = new LinkedHashMap<String, Map<String, String[]>>();
			charts.put(ChartTypes.METER_GAUGE.getPath(), getCharts());
			component = new ChartsSummary(charts);
			break;
		}
		return component;
	}

	public static Map<String, String[]> getCharts() {
		Map<String, String[]> charts = new LinkedHashMap<String, String[]>();
		for (MeterGaugeChart chart : MeterGaugeChart.values()) {
			charts.put(chart.getPath(), new String[] { chart.getDescription(),
					chart.getLongDescription() });
		}
		return charts;
	}

}
