/**
 * Copyright (C) 2012-2013  Dušan Vejnovič  <vaadin@dussan.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dussan.dchartsdemo.charts.additional;

import org.dussan.dchartsdemo.ui.context.ChartContext;
import org.dussan.vaadin.dcharts.DCharts;
import org.dussan.vaadin.dcharts.base.elements.XYaxis;
import org.dussan.vaadin.dcharts.canvasoverlays.DashedHorizontalLine;
import org.dussan.vaadin.dcharts.canvasoverlays.HorizontalLine;
import org.dussan.vaadin.dcharts.data.DataSeries;
import org.dussan.vaadin.dcharts.data.Ticks;
import org.dussan.vaadin.dcharts.metadata.lines.LineCaps;
import org.dussan.vaadin.dcharts.metadata.renderers.AxisRenderers;
import org.dussan.vaadin.dcharts.metadata.renderers.SeriesRenderers;
import org.dussan.vaadin.dcharts.options.Axes;
import org.dussan.vaadin.dcharts.options.CanvasOverlay;
import org.dussan.vaadin.dcharts.options.Highlighter;
import org.dussan.vaadin.dcharts.options.Options;
import org.dussan.vaadin.dcharts.options.SeriesDefaults;

public class ChartWithCanvasOverlay extends ChartContext {

	private static final long serialVersionUID = -3679249639565843052L;

	@Override
	protected void init() {
		DataSeries dataSeries = new DataSeries().add(2, 6, 7, 10);

		SeriesDefaults seriesDefaults = new SeriesDefaults()
				.setRenderer(SeriesRenderers.BAR);

		Axes axes = new Axes().addAxis(new XYaxis().setRenderer(
				AxisRenderers.CATEGORY).setTicks(
				new Ticks().add("a", "b", "c", "d")));

		Highlighter highlighter = new Highlighter().setShow(false);

		CanvasOverlay canvasOverlay = new CanvasOverlay()
				.setShow(true)
				.setObject(
						new HorizontalLine().setY(4).setLineWidth(6)
								.setColor("rgb(100, 55, 124)").setShadow(false))
				.setObject(
						new HorizontalLine().setY(6).setLineWidth(12)
								.setXminOffset("8px").setXmaxOffset("29px")
								.setColor("rgb(50, 55, 30)").setShadow(false))
				.setObject(
						new DashedHorizontalLine().setY(8).setLineWidth(2)
								.setXoffset(1).setColor("rgb(133, 120, 24)")
								.setShadow(false))
				.setObject(
						new HorizontalLine().setY(10).setLineWidth(3)
								.setXoffset(0).setColor("rgb(89, 198, 154)")
								.setShadow(false))
				.setObject(
						new DashedHorizontalLine().setY(14).setLineWidth(5)
								.setDashPattern(16, 12).setXoffset(0)
								.setLineCap(LineCaps.ROUND)
								.setColor("rgb(66, 98, 144)").setShadow(false));

		Options options = new Options().setSeriesDefaults(seriesDefaults)
				.setAxes(axes).setHighlighter(highlighter)
				.setCanvasOverlay(canvasOverlay);

		DCharts chart = new DCharts();
		chart.setWidth(450, Unit.PIXELS);
		chart.setHeight(300, Unit.PIXELS);
		chart.setDataSeries(dataSeries).setOptions(options);

		setChart(chart);
		setJqPlotCode("$(document).ready(function(){\n"//
				+ "\tvar s1 = [2, 6, 7, 10];\n"//
				+ "\tvar ticks = ['a', 'b', 'c', 'd'];\n"//
				+ "\n"//
				+ "\tplot = $.jqplot('chart1', [s1], {\n"//
				+ "\t\tseriesDefaults:{\n"//
				+ "\t\t\trenderer:$.jqplot.BarRenderer,\n"//
				+ "\t\t},\n"//
				+ "\t\taxes: {\n"//
				+ "\t\t\txaxis: {\n"//
				+ "\t\t\t\trenderer: $.jqplot.CategoryAxisRenderer,\n"//
				+ "\t\t\t\tticks: ticks\n"//
				+ "\t\t\t}\n"//
				+ "\t\t},\n"//
				+ "\t\thighlighter: { show: false },\n"//
				+ "\t\tcanvasOverlay: {\n"//
				+ "\t\t\tshow: true,\n"//
				+ "\t\t\tobjects: [\n"//
				+ "\t\t\t\t{horizontalLine:\n"//
				+ "\t\t\t\t\t{show: true,\n"//
				+ "\t\t\t\t\tshadow: false,\n"//
				+ "\t\t\t\t\tlineWidth: 6,\n"//
				+ "\t\t\t\t\tcolor: \"rgb(100, 55, 124)\",\n"//
				+ "\t\t\t\t\ty: 4}\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\t\t{horizontalLine:\n"//
				+ "\t\t\t\t\t{show: true,\n"//
				+ "\t\t\t\t\txmaxOffset: \"29px\",\n"//
				+ "\t\t\t\t\tshadow: false,\n"//
				+ "\t\t\t\t\txminOffset: \"8px\",\n"//
				+ "\t\t\t\t\tlineWidth: 12,\n"//
				+ "\t\t\t\t\tcolor: \"rgb(50, 55, 30)\",\n"//
				+ "\t\t\t\t\ty: 6}\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\t\t{dashedHorizontalLine:\n"//
				+ "\t\t\t\t\t{show: true,\n"//
				+ "\t\t\t\t\tshadow: false,\n"//
				+ "\t\t\t\t\tlineWidth: 2,\n"//
				+ "\t\t\t\t\txOffset: 2,\n"//
				+ "\t\t\t\t\tcolor: \"rgb(133, 120, 24)\",\n"//
				+ "\t\t\t\t\ty: 8}\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\t\t{horizontalLine:\n"//
				+ "\t\t\t\t\t{show: true,\n"//
				+ "\t\t\t\t\tshadow: false,\n"//
				+ "\t\t\t\t\tlineWidth: 3,\n"//
				+ "\t\t\t\t\txOffset: 0,\n"//
				+ "\t\t\t\t\tcolor: \"rgb(89, 198, 154)\",\n"//
				+ "\t\t\t\t\ty: 10}\n"//
				+ "\t\t\t\t},\n"//
				+ "\t\t\t\t{dashedHorizontalLine:\n"//
				+ "\t\t\t\t\t{dashPattern: [16, 12],\n"//
				+ "\t\t\t\t\tshow: true,\n"//
				+ "\t\t\t\t\tshadow: false,\n"//
				+ "\t\t\t\t\tlineCap: \"round\",\n"//
				+ "\t\t\t\t\tlineWidth: 5,\n"//
				+ "\t\t\t\t\txOffset: 0,\n"//
				+ "\t\t\t\t\tcolor: \"rgb(66, 98, 144)\",\n"//
				+ "\t\t\t\t\ty: 14}\n"//
				+ "\t\t\t\t}\n"//
				+ "\t\t\t]\n"//
				+ "\t\t}\n"//
				+ "\t});\n"//
				+ "});");
		setDChatsCode("DataSeries dataSeries = new DataSeries()\n"//
				+ "\t.add(2, 6, 7, 10);\n"//
				+ "\n"//
				+ "SeriesDefaults seriesDefaults = new SeriesDefaults()\n"//
				+ "\t.setRenderer(SeriesRenderers.BAR);\n"//
				+ "\n"//
				+ "Axes axes = new Axes()\n"//
				+ "\t.addAxis(\n"//
				+ "\t\tnew XYaxis()\n"//
				+ "\t\t\t.setRenderer(AxisRenderers.CATEGORY)\n"//
				+ "\t\t\t.setTicks(\n"//
				+ "\t\t\t\tnew Ticks()\n"//
				+ "\t\t\t\t\t.add(\"a\", \"b\", \"c\", \"d\")))\n"//
				+ "\n"//
				+ "Highlighter highlighter = new Highlighter()\n"//
				+ "\t.setShow(false);\n"//
				+ "\n"//
				+ "CanvasOverlay canvasOverlay = new CanvasOverlay())\n"//
				+ "\t.setShow(true))\n"//
				+ "\t.setObject()\n"//
				+ "\t\tnew HorizontalLine()\n"//
				+ "\t\t\t.setY(4)\n"//
				+ "\t\t\t.setLineWidth(6)\n"//
				+ "\t\t\t.setColor(\"rgb(100, 55, 124)\")\n"//
				+ "\t\t\t.setShadow(false))\n"//
				+ "\t.setObject(\n"//
				+ "\t\tnew HorizontalLine()\n"//
				+ "\t\t\t.setY(6)\n"//
				+ "\t\t\t.setLineWidth(12)\n"//
				+ "\t\t\t.setXminOffset(\"8px\")\n"//
				+ "\t\t\t.setXmaxOffset(\"29px\")\n"//
				+ "\t\t\t.setColor(\"rgb(50, 55, 30)\")\n"//
				+ "\t\t\t.setShadow(false))\n"//
				+ "\t.setObject(\n"//
				+ "\t\tnew DashedHorizontalLine()\n"//
				+ "\t\t\t.setY(8)\n"//
				+ "\t\t\t.setLineWidth(2)\n"//
				+ "\t\t\t.setXoffset(1)\n"//
				+ "\t\t\t.setColor(\"rgb(133, 120, 24)\")\n"//
				+ "\t\t\t.setShadow(false))\n"//
				+ "\t.setObject(\n"//
				+ "\t\tnew HorizontalLine()\n"//
				+ "\t\t\t.setY(10)\n"//
				+ "\t\t\t.setLineWidth(3)\n"//
				+ "\t\t\t.setXoffset(0)\n"//
				+ "\t\t\t.setColor(\"rgb(89, 198, 154)\")\n"//
				+ "\t\t\t.setShadow(false))\n"//
				+ "\t.setObject(\n"//
				+ "\t\tnew DashedHorizontalLine()\n"//
				+ "\t\t\t.setY(14)\n"//
				+ "\t\t\t.setLineWidth(5)\n"//
				+ "\t\t\t.setDashPattern(16, 12)\n"//
				+ "\t\t\t.setXoffset(0)\n"//
				+ "\t\t\t.setLineCap(LineCaps.ROUND)\n"//
				+ "\t\t\t.setColor(\"rgb(66, 98, 144)\")\n"//
				+ "\t\t\t.setShadow(false))\n"// ;
				+ "\n"//
				+ "Options options = new Options()\n"//
				+ "\t.setSeriesDefaults(seriesDefaults)\n"//
				+ "\t.setAxes(axes)\n"//
				+ "\t.setHighlighter(highlighter)\n"//
				+ "\t.setCanvasOverlay(canvasOverlay);\n"//
				+ "\n"//
				+ "DCharts chart = new DCharts()\n"//
				+ "\t.setDataSeries(dataSeries)\n"//
				+ "\t.setOptions(options)\n"//
				+ "\t.show();");
	}

}
